/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.lib.internal;

import java.util.Collection;
import java.util.Properties;
import javax.script.ScriptContext;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.ItemInterceptor;
import org.eclipse.scada.configuration.component.generator.interceptor.AbstractItemInterceptorHandler;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.modbus.ModbusDataType;
import org.eclipse.scada.configuration.modbus.ModbusExporter;
import org.eclipse.scada.configuration.modbus.ModbusExporterDevice;
import org.eclipse.scada.configuration.modbus.ModbusExporterInterceptor;
import org.eclipse.scada.configuration.modbus.ModbusExporterItem;
import org.eclipse.scada.configuration.modbus.ModbusFactory;
import org.eclipse.scada.configuration.modbus.lib.internal.ModbusProcessor;
import org.eclipse.scada.configuration.script.Script;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.configuration.world.osgi.ApplicationModule;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.utils.script.ScriptExecutor;

public class ModbusExporterInterceptorHandler
extends AbstractItemInterceptorHandler {
    protected boolean processInterceptItem(Item item, ItemInterceptor interceptorElement, GeneratorContext.MasterContext masterContext, Properties properties) {
        ModbusExporterInterceptor interceptor = (ModbusExporterInterceptor)interceptorElement;
        Script script = interceptor.getScript();
        ScriptEngineManager manager = new ScriptEngineManager();
        try {
            ScriptExecutor executor = new ScriptExecutor(manager, script.getLanguage(), script.getSource(), null);
            SimpleScriptContext context = new SimpleScriptContext();
            ModbusProcessor modbus = new ModbusProcessor(this, interceptor, masterContext, item);
            context.setAttribute("MODBUS", modbus, 100);
            context.setAttribute("item", item, 100);
            context.setAttribute("properties", properties, 100);
            executor.execute((ScriptContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process script", e);
        }
        return true;
    }

    public void handleExport(ModbusExporterInterceptor interceptor, GeneratorContext.MasterContext masterContext, Item item, int port, int slaveId, int offset, ModbusDataType type) {
        ModbusExporter exporter = this.createOrFindExporter(masterContext);
        if (exporter == null) {
            throw new RuntimeException("Failed to find modbus exporter");
        }
        ModbusExporterDevice device = this.createOrFindDevice(interceptor, masterContext, exporter, port, slaveId);
        ModbusExporterItem exporterItem = ModbusFactory.eINSTANCE.createModbusExporterItem();
        device.getItems().add((Object)exporterItem);
        exporterItem.setOffset(offset);
        exporterItem.setSource(item);
        exporterItem.setType(type);
    }

    private ModbusExporterDevice createOrFindDevice(ModbusExporterInterceptor interceptor, GeneratorContext.MasterContext masterContext, ModbusExporter exporter, int port, int slaveId) {
        ModbusExporterDevice device2;
        for (ModbusExporterDevice device2 : exporter.getDevices()) {
            if (device2.getPort().getPortNumber() != port) continue;
            if (device2.getSlaveId() != slaveId) {
                throw new IllegalStateException(String.format("At the moment each modbus exporter can only handle one slave id per port", new Object[0]));
            }
            return device2;
        }
        device2 = ModbusFactory.eINSTANCE.createModbusExporterDevice();
        device2.setDataOrder(interceptor.getSettings().getDataOrder());
        device2.setSlaveId(slaveId);
        device2.getProperties().addAll(EcoreUtil.copyAll((Collection)interceptor.getSettings().getProperties()));
        device2.setPort(Endpoints.registerEndpoint((Application)masterContext.getImplementation(), (int)port, (ServiceBinding)Endpoints.reference((EObject)device2), (String)String.format("Modbus Exporter: %s", masterContext.getDefinition().getName())));
        exporter.getDevices().add((Object)device2);
        return device2;
    }

    private ModbusExporter createOrFindExporter(GeneratorContext.MasterContext masterContext) {
        for (ApplicationModule module : masterContext.getImplementation().getModules()) {
            if (!(module instanceof ModbusExporter)) continue;
            return (ModbusExporter)module;
        }
        ModbusExporter exporter = ModbusFactory.eINSTANCE.createModbusExporter();
        masterContext.getImplementation().getModules().add((Object)exporter);
        return exporter;
    }
}

