/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.da.server.ui.util.ManagementInterfaceProvider;
import org.eclipse.scada.da.server.ui.util.ServerEndpointImpl;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.beans.AbstractPropertyChange;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.statushandlers.StatusManager;

public class ServerDescriptorImpl
extends AbstractPropertyChange
implements ServerDescriptor {
    private final Hive hive;
    private boolean running;
    private final WritableSet endpoints;
    private final Set<ServerEndpointImpl> endpointImpls = new HashSet<ServerEndpointImpl>();
    private final String labelAddition;
    private Throwable error;
    private final ManagementInterfaceProvider mgtProvider;

    public ServerDescriptorImpl(Realm realm, Hive hive, Set<Export> exporters, String labelAddition) {
        this.hive = hive;
        this.endpoints = new WritableSet(realm);
        this.labelAddition = labelAddition;
        if (exporters != null) {
            for (Export exporter : exporters) {
                ServerEndpointImpl endpoint = new ServerEndpointImpl(exporter);
                this.addEndpoint(endpoint);
            }
        }
        this.mgtProvider = (ManagementInterfaceProvider)AdapterHelper.adapt((Object)hive, ManagementInterfaceProvider.class, (boolean)true);
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        for (ServerEndpointImpl endpoint : this.endpointImpls) {
            endpoint.dispose();
        }
        this.endpointImpls.clear();
        if (!this.endpoints.isDisposed()) {
            this.endpoints.clear();
            this.endpoints.dispose();
        }
    }

    protected void setRunning(boolean running) {
        this.running = running;
        this.firePropertyChange("running", this.running, this.running);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void start() throws CoreException {
        try {
            this.hive.start();
            this.setRunning(true);
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e);
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (Throwable)e));
        }
        MultiStatus ms = new MultiStatus("org.eclipse.scada.da.server.ui", 0, "Starting endpoints", null);
        for (ServerEndpointImpl endpoint : this.endpointImpls) {
            try {
                endpoint.start();
            }
            catch (CoreException e) {
                ms.add(e.getStatus());
            }
        }
        this.throwMultiStatus(ms);
    }

    @Override
    public void stop() throws CoreException {
        try {
            this.hive.stop();
            this.setRunning(false);
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e);
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui", (Throwable)e));
        }
        MultiStatus ms = new MultiStatus("org.eclipse.scada.da.server.ui", 0, "Stopping endpoints", null);
        for (ServerEndpointImpl endpoint : this.endpointImpls) {
            try {
                endpoint.stop();
            }
            catch (CoreException e) {
                ms.add(e.getStatus());
            }
        }
        this.throwMultiStatus(ms);
    }

    public void throwMultiStatus(MultiStatus ms) throws CoreException {
        if (!ms.isOK()) {
            if (ms.getChildren().length == 1) {
                throw new CoreException(ms.getChildren()[0]);
            }
            throw new CoreException((IStatus)ms);
        }
    }

    @Override
    public String getAdditionalLabel() {
        return this.labelAddition;
    }

    @Override
    public String getLabel() {
        try {
            return (String)PojoProperties.value((String)"hiveId").getValue((Object)this.hive);
        }
        catch (Exception exception) {
            return this.hive.toString();
        }
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public IObservableSet getEndpoints() {
        return this.endpoints;
    }

    @Override
    public Hive getHive() {
        return this.hive;
    }

    @Override
    public boolean hasManagementInterface() {
        return this.mgtProvider != null;
    }

    @Override
    public void createManagementInterface(Composite parent) {
        this.mgtProvider.create(parent);
    }

    protected void addEndpoint(final ServerEndpointImpl endpoint) {
        this.endpointImpls.add(endpoint);
        this.endpoints.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ServerDescriptorImpl.this.endpoints.isDisposed()) {
                    ServerDescriptorImpl.this.endpoints.add((Object)endpoint);
                }
            }
        });
    }

    protected void removeEndpoint(final ServerEndpointImpl endpoint) {
        this.endpointImpls.remove(endpoint);
        this.endpoints.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ServerDescriptorImpl.this.endpoints.isDisposed()) {
                    ServerDescriptorImpl.this.endpoints.remove((Object)endpoint);
                }
            }
        });
    }

    protected void setError(Throwable error) {
        this.error = error;
        this.firePropertyChange("error", this.error, this.error);
    }

    @Override
    public Throwable getError() {
        return this.error;
    }
}

