/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.world.deployment.MappingEntry;
import org.eclipse.scada.configuration.world.deployment.Mappings;

public abstract class AbstractMapper {
    protected abstract Mappings getMappings();

    protected void replaceName(EObject object, EStructuralFeature feature) {
        String hostname = (String)object.eGet(feature);
        if (hostname == null) {
            return;
        }
        Mappings mappings = this.getMappings();
        for (MappingEntry entry : mappings.getEntries()) {
            String newName = entry.map(hostname);
            if (newName == null) continue;
            object.eSet(feature, (Object)newName);
            return;
        }
        switch (mappings.getFallbackMode()) {
            case IGNORE: {
                return;
            }
            case FAIL: {
                throw new IllegalStateException(String.format("No node mapping for: %s", hostname));
            }
        }
    }
}

