/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.CommonDriver;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.lib.NodeElementProcessor;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonHandler
implements NodeElementProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CommonHandler.class);
    protected final ApplicationNode applicationNode;

    protected abstract void handleProcess(IFolder var1, IProgressMonitor var2, Map<String, String> var3) throws Exception;

    public CommonHandler(ApplicationNode applicationNode) {
        this.applicationNode = applicationNode;
    }

    @Override
    public void process(String phase, IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        if (phase != null && !"package".equals(phase)) {
            return;
        }
        if (Boolean.parseBoolean(properties.get("skipDeployment"))) {
            return;
        }
        this.handleProcess(nodeDir, monitor, properties);
        monitor.done();
    }

    protected abstract String getBaseFolderName();

    public String getPackageName() {
        return String.valueOf(Nodes.makeName((Node)this.applicationNode)) + "-configuration";
    }

    protected File getPackageFolder(IFolder nodeDir) {
        File folder = nodeDir.getFolder(this.getBaseFolderName()).getLocation().toFile();
        logger.debug("Output folder: {}", (Object)folder);
        return new File(folder, this.getPackageName());
    }

    protected boolean needP2() {
        for (Application app : this.applicationNode.getApplications()) {
            if (!(app instanceof EquinoxApplication)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> makeDriverList() {
        HashSet<String> result = new HashSet<String>();
        for (Application app : this.applicationNode.getApplications()) {
            if (!(app instanceof CommonDriver)) continue;
            result.add(app.getName());
        }
        return result;
    }

    protected Set<String> makeEquinoxList() {
        HashSet<String> result = new HashSet<String>();
        for (Application app : this.applicationNode.getApplications()) {
            if (!(app instanceof EquinoxApplication)) continue;
            result.add(app.getName());
        }
        return result;
    }
}

