/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import org.eclipse.scada.configuration.world.lib.deployment.startup.StartupHandler;

public class ScriptMaker {
    private final StartupHandler handler;

    public ScriptMaker(StartupHandler handler) {
        this.handler = handler;
    }

    public String makePreInst() {
        if (this.handler == null) {
            return "";
        }
        return this.make(this.handler.preinstCommands());
    }

    public String makePostInst() {
        if (this.handler == null) {
            return "";
        }
        return this.make(this.handler.postinstCommands());
    }

    public String makePreRem() {
        if (this.handler == null) {
            return "";
        }
        return this.make(this.handler.preremCommands());
    }

    public String makePostRem() {
        if (this.handler == null) {
            return "";
        }
        return this.make(this.handler.postremCommands());
    }

    private String make(String[] commands) {
        StringBuilder sb = new StringBuilder("\n");
        this.append(sb, commands);
        sb.append("\n");
        return sb.toString();
    }

    public void appendStopDriver(StringBuilder sb, String driver) {
        if (this.handler == null) {
            return;
        }
        this.append(sb, this.handler.stopDriverCommand(driver));
    }

    public void appendStartDriver(StringBuilder sb, String driver) {
        if (this.handler == null) {
            return;
        }
        this.append(sb, this.handler.startDriverCommand(driver));
    }

    public void appendStopApp(StringBuilder sb, String driver) {
        if (this.handler == null) {
            return;
        }
        this.append(sb, this.handler.stopEquinoxCommand(driver));
    }

    public void appendStartApp(StringBuilder sb, String driver) {
        if (this.handler == null) {
            return;
        }
        this.append(sb, this.handler.startEquinoxCommand(driver));
    }

    private void append(StringBuilder sb, String[] commands) {
        if (commands == null) {
            return;
        }
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            if (command != null && !(command = command.trim()).isEmpty()) {
                sb.append(command).append(" || true\n");
            }
            ++n2;
        }
    }
}

