/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.redhat;

import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageDeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;

public class RedhatDeploymentContext
extends CommonPackageDeploymentContext {
    private final File tempBase;
    private final Map<String, FileInformation> tempInformationMap = new HashMap<String, FileInformation>();
    private final Map<String, FileInformation> directories = new HashMap<String, FileInformation>();

    public RedhatDeploymentContext(File tempBase, String packageName) {
        super(packageName);
        this.tempBase = tempBase;
    }

    public Map<String, FileInformation> getDirectories() {
        return this.directories;
    }

    @Override
    public void addDirectory(String targetDirectory, FileInformation fileInformation) {
        this.directories.put(targetDirectory, fileInformation);
    }

    @Override
    public void addFile(ContentProvider content, String targetFile, FileInformation fileInformation) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream resource = content.createInputStream();){
            File file = new File(this.tempBase, targetFile);
            file.getParentFile().mkdirs();
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(file));){
                ByteStreams.copy((InputStream)resource, (OutputStream)to);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.tempInformationMap.put(targetFile, fileInformation);
    }

    public Map<String, FileInformation> getFiles() {
        return this.tempInformationMap;
    }

    @Override
    public void runAfterInstallation(String script) {
        this.postInstallation.append('\n');
        this.postInstallation.append(script);
        this.postInstallation.append('\n');
    }

    @Override
    public void runAfterRemoval(String script) {
        this.postRemoval.append('\n');
        this.postRemoval.append("if [ $1 -eq 0 ]; then\n");
        this.postRemoval.append(script);
        this.postRemoval.append("\nfi\n");
    }
}

