/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.utils.TypeVisitor;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.Configurations;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.BlockGroup;
import org.eclipse.scada.configuration.world.osgi.BlockHandler;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.utils.str.StringHelper;

public class BlockingProcessor
extends BasicOscarProcessor
implements TypeVisitor<BlockGroup> {
    private final EquinoxApplication app;

    public BlockingProcessor(EquinoxApplication app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        try {
            new TypeWalker(BlockGroup.class).walk((EObject)this.app, (TypeVisitor)this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void visit(BlockGroup group) throws Exception {
        if (group.getHandlers().isEmpty()) {
            return;
        }
        ArrayList<String> masterIds = new ArrayList<String>(group.getHandlers().size());
        for (BlockHandler handler : group.getHandlers()) {
            masterIds.add(Items.makeMasterId(handler.getItem()));
        }
        Collections.sort(masterIds);
        String blockId = Names.makeName((NamedDocumentable)group);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("master.id", StringHelper.join(masterIds, (String)","));
        HashMap<String, String> infoAttributes = new HashMap<String, String>();
        Configurations.fillAttributesWithHierarchy(infoAttributes, (List<String>)group.getHierarchy());
        Configurations.applyInfoAttributes(infoAttributes, data);
        this.addData("org.eclipse.scada.da.master.common.block", blockId, data);
    }
}

