/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class Configurations {
    public static final Set<String> groupsSum = new TreeSet<String>(Arrays.asList("manual", "error", "alarm", "ackRequired", "blocked", "info", "warning"));

    private Configurations() {
    }

    public static void applyInfoAttributes(Map<String, String> attributes, Map<String, String> data) {
        Configurations.injectAttributes(attributes, "info.", data);
    }

    public static void fillAttributesWithHierarchy(Map<String, String> attributes, List<String> hierarchy) {
        int i = 0;
        for (String level : hierarchy) {
            attributes.put(String.format("level.%d", i), level);
            ++i;
        }
    }

    private static void injectAttributes(Map<String, String> attributes, String prefix, Map<String, String> data) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() == null || entry.getKey().isEmpty()) continue;
            data.put(String.valueOf(prefix) + entry.getKey(), entry.getValue());
        }
    }
}

