/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.IODirection;
import org.eclipse.scada.configuration.world.osgi.ItemExport;
import org.eclipse.scada.configuration.world.osgi.ItemInformation;
import org.eclipse.scada.utils.str.StringHelper;

public class ItemExportProcessor
extends BasicOscarProcessor {
    private final EquinoxApplication app;

    public ItemExportProcessor(EquinoxApplication app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process() {
        for (Exporter exporter : this.app.getExporter()) {
            if (!(exporter instanceof DataAccessExporter)) continue;
            this.processExporter((DataAccessExporter)exporter);
        }
    }

    private void processExporter(DataAccessExporter exporter) {
        for (ItemExport export : exporter.getExports()) {
            String masterId = Items.makeMasterId(export.getItem());
            ItemInformation info = export.getItem().getInformation();
            String description = info != null ? info.getDescription() : null;
            this.addAlias(String.valueOf(Names.makeName((NamedDocumentable)exporter)) + "/" + export.getExportName(), export.getExportName(), masterId, (EList<IODirection>)info.getIoDirections(), description);
        }
    }

    private void addAlias(String id, String itemId, String dataSourceId, EList<IODirection> directions, String description) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("datasource.id", dataSourceId);
        data.put("item.id", itemId);
        if (directions != null) {
            ArrayList<String> dirs = new ArrayList<String>(2);
            for (IODirection dir : directions) {
                dirs.add(dir.name());
            }
            Collections.sort(dirs);
            data.put("io.directions", StringHelper.join(dirs, (String)","));
        }
        if (description != null) {
            data.put("description", description);
        }
        this.addData("da.dataitem.datasource", id, data);
    }
}

