/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.AverageItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.ChangeCounterItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.ConstantItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.DeltaItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.FormulaItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.GlobalSummaryItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.MovingAverageItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.PersistentItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.ProxyItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.ReferenceItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.ScriptItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.SourceItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.SummaryItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.TransientItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.WeakReferenceDataSourceItemGenerator;
import org.eclipse.scada.configuration.world.osgi.AverageItem;
import org.eclipse.scada.configuration.world.osgi.ChangeCounterItem;
import org.eclipse.scada.configuration.world.osgi.ConstantItem;
import org.eclipse.scada.configuration.world.osgi.DeltaItem;
import org.eclipse.scada.configuration.world.osgi.FormulaItem;
import org.eclipse.scada.configuration.world.osgi.GlobalSummaryItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.MovingAverageItem;
import org.eclipse.scada.configuration.world.osgi.PersistentItem;
import org.eclipse.scada.configuration.world.osgi.ProxyItem;
import org.eclipse.scada.configuration.world.osgi.ReferenceItem;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.configuration.world.osgi.SummaryItem;
import org.eclipse.scada.configuration.world.osgi.TransientItem;
import org.eclipse.scada.configuration.world.osgi.WeakReferenceDataSourceItem;

public class ItemProcessor
extends BasicOscarProcessor {
    private final MasterServer app;
    private final MasterHandlerPriorities priorities;

    public ItemProcessor(MasterServer app, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
        this.priorities = priorities;
    }

    public void process() {
        for (Item item : this.app.getItems()) {
            this.processItem(item);
        }
    }

    private void processItem(Item item) {
        if (item instanceof SourceItem) {
            new SourceItemGenerator((SourceItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof SummaryItem) {
            new SummaryItemGenerator((SummaryItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof ConstantItem) {
            new ConstantItemGenerator((ConstantItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof PersistentItem) {
            new PersistentItemGenerator((PersistentItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof TransientItem) {
            new TransientItemGenerator((TransientItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof ProxyItem) {
            new ProxyItemGenerator((ProxyItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof ScriptItem) {
            new ScriptItemGenerator((ScriptItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof FormulaItem) {
            new FormulaItemGenerator((FormulaItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof MovingAverageItem) {
            new MovingAverageItemGenerator((MovingAverageItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof ChangeCounterItem) {
            new ChangeCounterItemGenerator((ChangeCounterItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof AverageItem) {
            new AverageItemGenerator((AverageItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof GlobalSummaryItem) {
            new GlobalSummaryItemGenerator((GlobalSummaryItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof WeakReferenceDataSourceItem) {
            new WeakReferenceDataSourceItemGenerator((WeakReferenceDataSourceItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof ReferenceItem) {
            new ReferenceItemGenerator((ReferenceItem)item, this.ctx, this.priorities).generate();
        } else if (item instanceof DeltaItem) {
            new DeltaItemGenerator((DeltaItem)item, this.ctx, this.priorities).generate();
        } else {
            throw new IllegalStateException(String.format("Item type '%s' is not supported", item.getClass().getName()));
        }
    }
}

