/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.event;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.event.EventHandlerProcessor;
import org.eclipse.scada.configuration.world.osgi.EventHandler;

public abstract class BasicEventHandlerProcessor
implements EventHandlerProcessor {
    private final String typeId;

    public BasicEventHandlerProcessor(String typeId) {
        this.typeId = typeId;
    }

    protected abstract Map<String, String> makeData(EventHandler var1, String var2);

    @Override
    public void process(EventHandler eventHandler, OscarContext ctx, int priority) {
        String id = String.format("%s", priority);
        this.addEntry(ctx, id, priority, this.makeData(eventHandler, id));
    }

    protected void addEntry(OscarContext ctx, String configurationId, int priority, Map<String, String> properties) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type.id", this.typeId);
        data.put("priority", "" + priority);
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            data.put("properties." + entry.getKey(), entry.getValue());
        }
        ctx.addData("org.eclipse.scada.ae.server.injector", configurationId, data);
    }
}

