/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.osgi.ChangeCounterItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.core.Variant;

public class ChangeCounterItemGenerator
extends ItemGenerator {
    private final ChangeCounterItem item;

    public ChangeCounterItemGenerator(ChangeCounterItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("changecounter");
    }

    @Override
    public void generate() {
        super.generate();
        this.addChangeCounterSource(this.makeSourceId());
    }

    private void addChangeCounterSource(String id) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.item.getBuffer() == null) {
            throw new IllegalArgumentException("item attribute 'buffer' is not set!");
        }
        data.put("buffered.datasource.id", this.item.getBuffer().getName());
        data.put("type", this.item.getType().getLiteral());
        data.put("onError", this.item.getOnError().getLiteral());
        int i = 0;
        for (Variant value : this.item.getValues()) {
            data.put("value." + i, value.toString());
            ++i;
        }
        this.addData("org.eclipse.scada.da.datasource.changecounter", id, data);
    }
}

