/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.GlobalSummaryItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.SummaryItem;

public class GlobalSummaryItemGenerator
extends ItemGenerator {
    private final GlobalSummaryItem item;

    public GlobalSummaryItemGenerator(GlobalSummaryItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    public void generate() {
        super.generate();
        this.addGlobalSummarySource();
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("globalSummary");
    }

    private void addGlobalSummarySource() {
        HashMap<String, String> data = new HashMap<String, String>();
        EObject container = this.item.eContainer();
        if (!(container instanceof MasterServer)) {
            return;
        }
        MasterServer app = (MasterServer)container;
        ArrayList<String> blacklist = new ArrayList<String>();
        for (Item item : app.getItems()) {
            if (item instanceof SummaryItem) {
                blacklist.add(Items.makeMasterId(item));
                continue;
            }
            if (!(item instanceof GlobalSummaryItem)) continue;
            blacklist.add(Items.makeMasterId(item));
        }
        Collections.sort(blacklist);
        data.put("attribute", this.item.getAttribute());
        data.put("onlyMaster", "true");
        int i = 0;
        for (String entry : blacklist) {
            data.put("blacklist." + i++, entry);
        }
        this.addData("org.eclipse.scada.da.server.osgi.summary.attribute", this.makeSourceId(), data);
    }
}

