/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.AttributesSummaryProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.BlockProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.BooleanMonitorProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.EventLoggerProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ItemFeatureProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.LevelMonitorProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ListMonitorProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ManualOverrideProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.NegateProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.RoundingProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ScaleProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ValueMapperProcessor;
import org.eclipse.scada.configuration.world.osgi.AttributesSummary;
import org.eclipse.scada.configuration.world.osgi.Block;
import org.eclipse.scada.configuration.world.osgi.BooleanMonitor;
import org.eclipse.scada.configuration.world.osgi.EventLogger;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemFeatureEntry;
import org.eclipse.scada.configuration.world.osgi.LevelMonitor;
import org.eclipse.scada.configuration.world.osgi.ListMonitor;
import org.eclipse.scada.configuration.world.osgi.ManualOverride;
import org.eclipse.scada.configuration.world.osgi.Negate;
import org.eclipse.scada.configuration.world.osgi.Rounding;
import org.eclipse.scada.configuration.world.osgi.Scale;
import org.eclipse.scada.configuration.world.osgi.ValueMapper;

public abstract class ItemGenerator {
    private final Item item;
    private final OscarContext ctx;
    private final MasterHandlerPriorities priorities;

    public ItemGenerator(Item item, OscarContext ctx, MasterHandlerPriorities priorities) {
        this.item = item;
        this.ctx = ctx;
        this.priorities = priorities;
    }

    protected String makeId(String tag) {
        return Items.makeId(this.item, tag);
    }

    protected String makeMasterId() {
        return Items.makeMasterId(this.item);
    }

    protected abstract String makeSourceId();

    public void generate() {
        this.addMaster(this.makeMasterId(), this.makeSourceId());
        for (ItemFeatureEntry feature : this.item.getItemFeatures()) {
            ItemFeatureProcessor processor = this.findProcessor(feature);
            if (processor == null) {
                throw new IllegalStateException(String.format("Processor for item feature %s/%s not found", feature.getName(), feature.getClass().getName()));
            }
            processor.process(this.priorities, feature, this.ctx);
        }
    }

    private ItemFeatureProcessor findProcessor(ItemFeatureEntry feature) {
        if (feature instanceof ManualOverride) {
            return new ManualOverrideProcessor();
        }
        if (feature instanceof LevelMonitor) {
            return new LevelMonitorProcessor();
        }
        if (feature instanceof AttributesSummary) {
            return new AttributesSummaryProcessor();
        }
        if (feature instanceof EventLogger) {
            return new EventLoggerProcessor();
        }
        if (feature instanceof ValueMapper) {
            return new ValueMapperProcessor();
        }
        if (feature instanceof Scale) {
            return new ScaleProcessor();
        }
        if (feature instanceof Negate) {
            return new NegateProcessor();
        }
        if (feature instanceof Rounding) {
            return new RoundingProcessor();
        }
        if (feature instanceof BooleanMonitor) {
            return new BooleanMonitorProcessor();
        }
        if (feature instanceof ListMonitor) {
            return new ListMonitorProcessor();
        }
        if (feature instanceof Block) {
            return new BlockProcessor();
        }
        return null;
    }

    protected void addMaster(String id, String dataSourceId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("datasource.id", dataSourceId);
        this.addData("master.item", id, data);
    }

    protected void addAlias(String id, String itemId, String dataSourceId, String description) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("datasource.id", dataSourceId);
        data.put("item.id", itemId);
        if (description != null) {
            data.put("description", description);
        }
        this.addData("da.dataitem.datasource", id, data);
    }

    protected void addData(String factoryId, String configurationId, Map<String, String> data) {
        this.ctx.addData(factoryId, configurationId, data);
    }
}

