/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.HashMap;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.world.PropertyEntry;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;

public class ScriptItemGenerator
extends ItemGenerator {
    private final ScriptItem item;

    public ScriptItemGenerator(ScriptItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    public void generate() {
        super.generate();
        this.addScriptSource();
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("script");
    }

    private void addScriptSource() {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = this.makeSourceId();
        Helper.addOptional(data, "engine", this.item.getScriptEngine());
        for (ItemReference input : this.item.getInputs()) {
            data.put("datasource." + input.getName(), Items.makeMasterId(input.getItem()));
        }
        for (ItemReference command : this.item.getCommands()) {
            data.put("writeSource." + command.getName(), Items.makeMasterId(command.getItem()));
        }
        if (this.item.getInitScript() != null) {
            Helper.addOptional(data, "init", this.item.getInitScript().getCode());
        }
        if (this.item.getUpdateScript() != null) {
            Helper.addOptional(data, "updateCommand", this.item.getUpdateScript().getCode());
        }
        if (this.item.getWriteCommandScript() != null) {
            Helper.addOptional(data, "writeCommand", this.item.getWriteCommandScript().getCode());
        }
        if (this.item.getTimer() != null) {
            data.put("timer", "" + this.item.getTimer().getPeriod());
            if (this.item.getTimer().getScript() != null) {
                Helper.addOptional(data, "timerCommand", this.item.getTimer().getScript().getCode());
            }
        }
        for (PropertyEntry entry : this.item.getInitProperties()) {
            if (Properties.isEmpty((PropertyEntry)entry)) continue;
            data.put("initProperty." + entry.getKey(), entry.getValue());
        }
        this.addData("org.eclipse.scada.da.datasource.script", id, data);
    }
}

