/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item.features;

import java.util.HashMap;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.Features;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ItemFeatureProcessor;
import org.eclipse.scada.configuration.world.osgi.BooleanMonitor;
import org.eclipse.scada.configuration.world.osgi.ItemFeatureEntry;

public class BooleanMonitorProcessor
implements ItemFeatureProcessor {
    @Override
    public void process(MasterHandlerPriorities priorities, ItemFeatureEntry rawFeature, OscarContext context) {
        BooleanMonitor feature = (BooleanMonitor)rawFeature;
        String configurationId = Features.configurationItem((ItemFeatureEntry)feature);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("active", "" + feature.isActive());
        data.put("reference", "" + feature.isReferenceValue());
        data.put("requireAck", "" + feature.isRequireAck());
        data.put("suppressEvents", "" + feature.isSuppressEvents());
        Helper.addOptional(data, "message", feature.getMessage());
        data.put("severity", feature.getSeverity().name());
        Helper.addOptional(data, "demote.prefix", feature.getDemotePrefix());
        int priority = priorities.findPriority("org.eclipse.scada.ae.monitor.bit", configurationId);
        Items.fillForMasterHandler(data, feature.getItem(), priority);
        context.addData("org.eclipse.scada.ae.monitor.bit", configurationId, data);
    }
}

