/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item.features;

import java.util.HashMap;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.Features;
import org.eclipse.scada.configuration.world.lib.oscar.item.features.ItemFeatureProcessor;
import org.eclipse.scada.configuration.world.osgi.ItemFeatureEntry;
import org.eclipse.scada.configuration.world.osgi.ListMonitor;
import org.eclipse.scada.configuration.world.osgi.ListMonitorEntry;

public class ListMonitorProcessor
implements ItemFeatureProcessor {
    @Override
    public void process(MasterHandlerPriorities priorities, ItemFeatureEntry rawFeature, OscarContext context) {
        ListMonitor feature = (ListMonitor)rawFeature;
        String configurationId = Features.configurationItem((ItemFeatureEntry)feature);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("defaultSeverity", feature.getDefaultSeverity().name());
        data.put("defaultAck", "" + feature.isDefaultAck());
        data.put("monitorType", feature.getMonitorType());
        Helper.addOptional(data, "demote.prefix", feature.getDemotePrefix());
        Helper.addOptional(data, "messageAttribute", feature.getMessageAttribute());
        Helper.addOptional(data, "message", feature.getMessage());
        int i = 0;
        for (ListMonitorEntry entry : feature.getEntries()) {
            String value = entry.getValue().toString();
            if (entry.getRequireAck() != null) {
                String prefix = entry.getRequireAck() != false ? "ack" : "nak";
                data.put(String.format("values.%s.%s", prefix, i), value);
            }
            if (entry.getSeverity() != null) {
                data.put(String.format("values.%s.%s", entry.getSeverity().name(), i), value);
            }
            ++i;
        }
        int priority = priorities.findPriority("org.eclipse.scada.ae.monitor.list", configurationId);
        Items.fillForMasterHandler(data, feature.getItem(), priority);
        context.addData("org.eclipse.scada.ae.monitor.list", configurationId, data);
    }
}

