/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.setup;

import java.util.Collection;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.setup.SetupModuleHandler;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;
import org.eclipse.scada.configuration.world.setup.SetupModule;
import org.eclipse.scada.configuration.world.setup.SubContainerModule;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;

public class SubModuleHandler
implements SetupModuleHandler {
    private final SubContainerModule module;

    public SubModuleHandler(SubContainerModule module) {
        this.module = module;
    }

    @Override
    public void perform(DeploymentContext context, OperatingSystemDescriptor operatingSystem) throws Exception {
        SubModuleHandler.runSetup(context, (Collection<? extends SetupModule>)this.module.getContainer().getModules(), operatingSystem);
    }

    public static void runSetup(DeploymentContext context, Collection<? extends SetupModule> modules, OperatingSystemDescriptor operatingSystem) throws Exception {
        for (SetupModule setupModule : modules) {
            SetupModuleHandler handler = (SetupModuleHandler)AdapterHelper.adapt((Object)setupModule, SetupModuleHandler.class, (boolean)true);
            if (handler == null) {
                throw new IllegalStateException(String.format("Unable to find setup handler for module: %s", setupModule.eClass().getName()));
            }
            handler.perform(context, operatingSystem);
        }
    }
}

