/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.validator.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.validator.DataSourceDescriptor;
import org.eclipse.scada.configuration.world.lib.validator.handler.LoopHandler;
import org.eclipse.scada.configuration.world.lib.validator.handler.SummaryDataSourceDescriptor;

public class SummaryHandler
implements LoopHandler {
    private final Set<SummaryDataSourceDescriptor> ourSources = new HashSet<SummaryDataSourceDescriptor>();

    @Override
    public Set<DataSourceDescriptor> getNode(String configurationId, Map<String, String> parameters) {
        SummaryDataSourceDescriptor desc = new SummaryDataSourceDescriptor(configurationId, this.makeBlacklist(parameters), parameters.containsKey("onlyMaster"));
        this.ourSources.add(desc);
        return new HashSet<DataSourceDescriptor>(Arrays.asList(desc));
    }

    private Set<String> makeBlacklist(Map<String, String> parameters) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith("blacklist.")) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    @Override
    public boolean providesDescriptors() {
        return true;
    }

    @Override
    public boolean providesPostProcessing() {
        return true;
    }

    @Override
    public void postProcess(Set<DataSourceDescriptor> descriptors) {
        for (SummaryDataSourceDescriptor our : this.ourSources) {
            for (DataSourceDescriptor desc : descriptors) {
                if (our.equals(desc) || our.getBlacklist().contains(desc.getId()) || our.isMasterOnly() && !desc.getId().endsWith(".master")) continue;
                our.addReference("datasource", desc.getId());
            }
        }
    }
}

