/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scada.configuration.generator.Generator;
import org.eclipse.scada.configuration.generator.GeneratorFactory;
import org.eclipse.scada.configuration.generator.text.AnnotationMessageProcessor;
import org.eclipse.scada.configuration.utils.Factories;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorLocator {
    private static final String ELE_GENERATE_FOR = "generateForType";
    private static final String ATTR_CLASS = "class";
    private static final String EXTP_GENERATOR_FACTORY = "org.eclipse.scada.configuration.generator.component.generator";
    private static final Object ELE_FACTORY = "factory";
    private static final Logger logger = LoggerFactory.getLogger(GeneratorLocator.class);
    private Map<Class<?>, Set<GeneratorFactory>> cache;
    private final IRegistryChangeListener changeListener = new IRegistryChangeListener(){

        public void registryChanged(IRegistryChangeEvent event) {
            GeneratorLocator.this.clearCache();
        }
    };
    private final BundleContext context;
    private final ILog log;

    public GeneratorLocator(BundleContext context, ILog log) {
        this.context = context;
        this.log = log;
    }

    protected void clearCache() {
        this.cache = null;
    }

    public Map<Class<?>, Set<GeneratorFactory>> getFactories() {
        if (this.cache == null) {
            logger.info("Rebuild factory cache");
            this.cache = new HashMap();
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_GENERATOR_FACTORY);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    IConfigurationElement ele = iConfigurationElementArray[n2];
                    if (ELE_FACTORY.equals(ele.getName())) {
                        GeneratorFactory factory;
                        logger.debug("Checking factory - factory: {}", (Object)ele.getAttribute(ATTR_CLASS));
                        try {
                            factory = (GeneratorFactory)ele.createExecutableExtension(ATTR_CLASS);
                        }
                        catch (CoreException e) {
                            this.log.log(e.getStatus());
                            logger.warn("Failed to create factory", (Throwable)e);
                            break block7;
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = ele.getChildren(ELE_GENERATE_FOR);
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement child = iConfigurationElementArray2[n4];
                            logger.debug("Checking for -> {}", (Object)child.getAttribute(ATTR_CLASS));
                            Class<?> sourceClass = this.makeSourceClass(child);
                            if (sourceClass != null) {
                                this.addCacheEntry(sourceClass, factory);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return this.cache;
    }

    private Class<?> makeSourceClass(IConfigurationElement ele) {
        return Factories.loadClass((BundleContext)this.context, (IConfigurationElement)ele, (String)ATTR_CLASS);
    }

    private void addCacheEntry(Class<?> sourceClass, GeneratorFactory factory) {
        logger.debug("Adding cache entry - sourceClass: {}, factory: {}", sourceClass, (Object)factory);
        Set<GeneratorFactory> factories = this.cache.get(sourceClass);
        if (factories == null) {
            factories = new HashSet<GeneratorFactory>();
            this.cache.put(sourceClass, factories);
        }
        factories.add(factory);
    }

    public Set<GeneratorFactory> getFactoriesFor(Object element) {
        Map<Class<?>, Set<GeneratorFactory>> factories = this.getFactories();
        HashSet<GeneratorFactory> result = new HashSet<GeneratorFactory>();
        for (Map.Entry<Class<?>, Set<GeneratorFactory>> entry : factories.entrySet()) {
            Class<?> clazz = entry.getKey();
            if (!clazz.isAssignableFrom(element.getClass())) continue;
            result.addAll((Collection<GeneratorFactory>)entry.getValue());
        }
        return result;
    }

    public Set<Generator> createGeneratorsFor(Object element) {
        HashSet<Generator> result = new HashSet<Generator>();
        Generator generator = (Generator)AdapterHelper.adapt((Object)element, Generator.class, (boolean)true);
        if (generator != null) {
            result.add(generator);
            new AnnotationMessageProcessor(generator).setMessages(null);
        }
        for (GeneratorFactory factory : this.getFactoriesFor(element)) {
            Collection<Generator> generators = factory.createGenerators(element);
            result.addAll(generators);
            for (Generator gen : generators) {
                new AnnotationMessageProcessor(gen).setMessages(null);
            }
        }
        logger.debug("{} generators found for {}", (Object)result.size(), element.getClass());
        return result;
    }

    public void start() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this.changeListener);
    }

    public void stop() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.changeListener);
    }
}

