/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.scada.configuration.world.DatabaseSettings;
import org.eclipse.scada.configuration.world.PropertyEntry;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.BundleStartLevel;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.StartBundle;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;

public final class Profiles {
    private Profiles() {
    }

    public static Map<String, Integer> makeStartLevelMap(Profile profile) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (StartBundle start : profile.getStart()) {
            result.put(start.getName(), -1);
        }
        for (BundleStartLevel bsl : profile.getSetbsl()) {
            result.put(bsl.getName(), bsl.getLevel());
        }
        return result;
    }

    public static Profile createOrGetCustomizationProfile(EquinoxApplication app) {
        Profile profile = app.getCustomizationProfile();
        if (profile == null) {
            profile = ProfileFactory.eINSTANCE.createProfile();
            app.setCustomizationProfile(profile);
        }
        return profile;
    }

    public static void addStartBundle(Profile profile, String name) {
        if (name == null) {
            return;
        }
        for (StartBundle bundle : profile.getStart()) {
            if (!name.equals(bundle.getName())) continue;
            return;
        }
        StartBundle sb = ProfileFactory.eINSTANCE.createStartBundle();
        sb.setName(name);
        profile.getStart().add((Object)sb);
    }

    public static void addSystemProperty(Profile profile, String key, Object value) {
        Profiles.removeSystemProperty(profile, key);
        SystemProperty prop = ProfileFactory.eINSTANCE.createSystemProperty();
        prop.setKey(key);
        if (value != null) {
            prop.setValue("" + value);
        } else {
            prop.setValue(null);
        }
        profile.getProperty().add((Object)prop);
    }

    public static void removeSystemProperty(Profile profile, String key) {
        Iterator i = profile.getProperty().iterator();
        while (i.hasNext()) {
            SystemProperty p = (SystemProperty)i.next();
            if (!p.getKey().equals(key)) continue;
            i.remove();
        }
    }

    public static void addProgramArugment(Profile profile, String argument) {
        profile.getArguments().add((Object)argument);
    }

    public static void addInclude(Profile profile, ResourceSet resourceSet, URI uri) {
        EObject content = resourceSet.getEObject(uri, true);
        if (!(content instanceof Profile)) {
            throw new IllegalStateException(String.format("URI '%s' must point to an object of type '%s'.", uri, Profile.class.getName()));
        }
        profile.getIncludes().add((Object)((Profile)content));
    }

    public static void addJdbcSystemProperties(Profile profile, String prefix, DatabaseSettings database) {
        if (database.getBundles() != null) {
            for (String bundle : database.getBundles()) {
                Profiles.addStartBundle(profile, bundle);
            }
            profile.getInstallationUnits().addAll((Collection)database.getBundles());
        }
        Profiles.addSystemProperty(profile, String.valueOf(prefix) + ".driver", database.getDriverName());
        Profiles.addSystemProperty(profile, String.valueOf(prefix) + ".loginTimeout", database.getLoginTimeout());
        for (PropertyEntry entry : database.getProperties()) {
            Profiles.addSystemProperty(profile, String.valueOf(prefix) + ".properties." + entry.getKey(), entry.getValue());
        }
    }

    public static boolean hasStartBundle(Profile profile, String name) {
        for (StartBundle sb : profile.getStart()) {
            if (!sb.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

