/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.security.impl;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.security.CA;
import org.eclipse.scada.configuration.security.Configuration;
import org.eclipse.scada.configuration.security.GenericScript;
import org.eclipse.scada.configuration.security.JavaScript;
import org.eclipse.scada.configuration.security.LogonRule;
import org.eclipse.scada.configuration.security.Rules;
import org.eclipse.scada.configuration.security.ScriptRule;
import org.eclipse.scada.configuration.security.SecurityFactory;
import org.eclipse.scada.configuration.security.SecurityPackage;
import org.eclipse.scada.configuration.security.SignatureRule;
import org.eclipse.scada.configuration.security.impl.CAImpl;
import org.eclipse.scada.configuration.security.impl.ConfigurationImpl;
import org.eclipse.scada.configuration.security.impl.GenericScriptImpl;
import org.eclipse.scada.configuration.security.impl.JavaScriptImpl;
import org.eclipse.scada.configuration.security.impl.LogonRuleImpl;
import org.eclipse.scada.configuration.security.impl.RulesImpl;
import org.eclipse.scada.configuration.security.impl.ScriptRuleImpl;
import org.eclipse.scada.configuration.security.impl.SignatureRuleImpl;

public class SecurityFactoryImpl
extends EFactoryImpl
implements SecurityFactory {
    public static SecurityFactory init() {
        try {
            SecurityFactory theSecurityFactory = (SecurityFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/Security");
            if (theSecurityFactory != null) {
                return theSecurityFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SecurityFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createScriptRule();
            }
            case 2: {
                return this.createLogonRule();
            }
            case 3: {
                return this.createSignatureRule();
            }
            case 5: {
                return this.createJavaScript();
            }
            case 6: {
                return this.createGenericScript();
            }
            case 7: {
                return this.createConfiguration();
            }
            case 8: {
                return this.createRules();
            }
            case 9: {
                return this.createCA();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createPatternFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ScriptRule createScriptRule() {
        ScriptRuleImpl scriptRule = new ScriptRuleImpl();
        return scriptRule;
    }

    @Override
    public LogonRule createLogonRule() {
        LogonRuleImpl logonRule = new LogonRuleImpl();
        return logonRule;
    }

    @Override
    public SignatureRule createSignatureRule() {
        SignatureRuleImpl signatureRule = new SignatureRuleImpl();
        return signatureRule;
    }

    @Override
    public JavaScript createJavaScript() {
        JavaScriptImpl javaScript = new JavaScriptImpl();
        return javaScript;
    }

    @Override
    public GenericScript createGenericScript() {
        GenericScriptImpl genericScript = new GenericScriptImpl();
        return genericScript;
    }

    @Override
    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        return configuration;
    }

    @Override
    public Rules createRules() {
        RulesImpl rules = new RulesImpl();
        return rules;
    }

    @Override
    public CA createCA() {
        CAImpl ca = new CAImpl();
        return ca;
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        return Pattern.compile(initialValue);
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public SecurityPackage getSecurityPackage() {
        return (SecurityPackage)this.getEPackage();
    }

    @Deprecated
    public static SecurityPackage getPackage() {
        return SecurityPackage.eINSTANCE;
    }
}

