/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.dialog;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.provider.InfrastructureItemProviderAdapterFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DriverSelectionDialog
extends TitleAreaDialog {
    private final World world;
    private final WritableValue driverValue = new WritableValue();

    public DriverSelectionDialog(Shell parentShell, World world) {
        super(parentShell);
        this.world = world;
        this.setHelpAvailable(false);
    }

    public Driver getDriver() {
        Object value = this.driverValue.getValue();
        if (value instanceof Driver) {
            return (Driver)value;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select driver");
        this.setMessage("Choose a driver from the world model");
        Composite composite = (Composite)super.createDialogArea(parent);
        ObservablesManager mgr = new ObservablesManager();
        final TreeViewer viewer = new TreeViewer(composite);
        viewer.setAutoExpandLevel(2);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DriverSelectionDialog.this.handleDoubleClick();
            }
        });
        mgr.runAndCollect(new Runnable(){

            @Override
            public void run() {
                DriverSelectionDialog.this.createDataModel(viewer);
            }
        });
        return composite;
    }

    protected void handleDoubleClick() {
        if (this.getDriver() != null) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void createDataModel(TreeViewer viewer) {
        final DataBindingContext dbc = new DataBindingContext();
        IObservableFactory listFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservableList) {
                    return (IObservableList)target;
                }
                if (target instanceof World) {
                    return EMFObservables.observeList((EObject)((EObject)target), (EStructuralFeature)InfrastructurePackage.Literals.WORLD__NODES);
                }
                if (target instanceof SystemNode) {
                    return EMFObservables.observeList((EObject)((EObject)target), (EStructuralFeature)InfrastructurePackage.Literals.SYSTEM_NODE__DRIVERS);
                }
                return null;
            }
        };
        InfrastructureItemProviderAdapterFactory adapterFactory = new InfrastructureItemProviderAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        ObservableListTreeContentProvider cp = new ObservableListTreeContentProvider(listFactory, null);
        viewer.setContentProvider((IContentProvider)cp);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput((Object)EMFObservables.observeList((EObject)this.world, (EStructuralFeature)InfrastructurePackage.Literals.WORLD__NODES));
        dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), (IObservableValue)this.driverValue);
        this.driverValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                DriverSelectionDialog.this.update();
            }
        });
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dbc.dispose();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.update();
        return result;
    }

    private void update() {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        button.setEnabled(this.getDriver() != null);
    }
}

