/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.wizard;

import javax.script.Compilable;
import javax.script.CompiledScript;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.configuration.component.tools.Activator;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.script.Scripts;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ScriptPage
extends WizardPage {
    private static final String PROP_SCRIPT = "scripts";
    private final WritableValue scriptValue = new WritableValue();
    private Compilable engine;
    private CompiledScript script;
    private Text text;
    private CCombo combo;
    private Button load;
    private Button delete;

    protected ScriptPage() {
        super("script");
    }

    public void createControl(Composite parent) {
        this.setTitle("Enter name script");
        final DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dbc.dispose();
            }
        });
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayoutData((Object)new GridData(4, 1, true, false));
        wrapper.setLayout((Layout)new GridLayout(4, false));
        this.combo = new CCombo(wrapper, 2056);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 100;
        this.combo.setLayoutData((Object)gd);
        Button store = new Button(wrapper, 8);
        store.setText("Store");
        store.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptPage.this.addScript();
            }
        });
        this.load = new Button(wrapper, 8);
        this.load.setText("Load");
        this.delete = new Button(wrapper, 8);
        this.delete.setText("Delete");
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptPage.this.deleteScript();
            }
        });
        this.text = new Text(wrapper, 2818);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.text), (IObservableValue)this.scriptValue, new UpdateValueStrategy().setAfterConvertValidator(new IValidator(){

            public IStatus validate(Object value) {
                return ScriptPage.this.validateScript(value);
            }
        }), null);
        this.fillScripts();
        this.setControl((Control)wrapper);
        this.load.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptPage.this.text.setText(ScriptPage.this.combo.getText());
            }
        });
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptPage.this.update();
            }
        });
    }

    protected void deleteScript() {
        this.combo.remove(this.combo.getSelectionIndex());
        this.combo.setText("");
        this.getDialogSettings().put(PROP_SCRIPT, this.combo.getItems());
        this.update();
    }

    private void update() {
        this.delete.setEnabled(this.combo.getSelectionIndex() >= 0);
        this.load.setEnabled(this.combo.getSelectionIndex() >= 0);
    }

    private void fillScripts() {
        String[] scripts = this.getDialogSettings().getArray(PROP_SCRIPT);
        if (scripts == null || scripts.length <= 0) {
            return;
        }
        this.combo.setItems(scripts);
        this.update();
    }

    public void addScript() {
        this.combo.add(this.text.getText());
        this.combo.select(this.combo.getItemCount() - 1);
        this.getDialogSettings().put(PROP_SCRIPT, this.combo.getItems());
    }

    protected IStatus validateScript(Object value) {
        this.script = null;
        try {
            this.script = this.makeScript(value);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.scada.configuration.component.tools", ExceptionHelper.getMessage((Throwable)e));
        }
        return new Status(1, "org.eclipse.scada.configuration.component.tools", "Enter a Java script fragment which returns the new name of each item");
    }

    public CompiledScript getScript() {
        return this.script;
    }

    private CompiledScript makeScript(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (this.engine == null) {
            this.engine = (Compilable)((Object)Scripts.createEngine((String)"JavaScript", (ClassLoader)Activator.class.getClassLoader()));
        }
        return this.engine.compile((String)value);
    }
}

