/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.validation;

import org.eclipse.scada.configuration.world.deployment.CommonDeploymentMechanism;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;
import org.eclipse.scada.configuration.world.setup.SetupModule;
import org.eclipse.scada.configuration.world.setup.SetupModuleContainer;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class CommonDeploymentMechanismValidator
extends TypedValidator<CommonDeploymentMechanism> {
    public CommonDeploymentMechanismValidator() {
        super(CommonDeploymentMechanism.class);
    }

    protected void validate(CommonDeploymentMechanism dep, ValidationContext ctx) {
        SetupModuleContainer smc = dep.getSetup();
        OperatingSystemDescriptor os = dep.getOperatingSystem();
        if (smc != null && os == null) {
            ctx.add("The deployment mechansim has a setup module container set but no operating system assigned", new Object[0]);
        } else if (smc != null) {
            smc.validateOperatingSystem(os, ctx);
        }
        if (dep.getAdditionalSetupModules() != null && !dep.getAdditionalSetupModules().isEmpty() && os == null) {
            ctx.add("The deployment mechansim has a additional setup modules but no operating system assigned", new Object[0]);
        } else if (smc != null) {
            for (SetupModule sm : dep.getAdditionalSetupModules()) {
                sm.validateOperatingSystem(os, ctx);
            }
        }
    }
}

