/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.configuration.world.osgi.TelnetConsole;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class TelnetConsoleValidator
extends TypedValidator<TelnetConsole> {
    private static final int MAX_PORT = 65536;

    public TelnetConsoleValidator() {
        super(TelnetConsole.class);
    }

    protected void validate(TelnetConsole target, ValidationContext context) {
        int port = target.getPort();
        if (port < 0) {
            context.add((EStructuralFeature)OsgiPackage.Literals.TELNET_CONSOLE__PORT, "Port must be a positive integer", new Object[0]);
        } else if (port == 0) {
            context.add((EStructuralFeature)OsgiPackage.Literals.TELNET_CONSOLE__PORT, Severity.WARNING, "Wildcard ports are not recommended", new Object[0]);
        } else if (port < 1024) {
            context.add((EStructuralFeature)OsgiPackage.Literals.TELNET_CONSOLE__PORT, Severity.WARNING, "Ports below 1024 are considered privileged for some operating systems and are not recommended", new Object[0]);
        } else if (port >= 65536) {
            context.add((EStructuralFeature)OsgiPackage.Literals.TELNET_CONSOLE__PORT, "Port must be lower than {0}", new Object[]{65536});
        }
        if (target.getHost() != null && target.getHost().isEmpty()) {
            context.add((EStructuralFeature)OsgiPackage.Literals.TELNET_CONSOLE__HOST, Severity.WARNING, "Binding to all interfaces might pose a security risk. Consider binding to 'localhost' instead.", new Object[]{65536});
        }
    }
}

