/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.lib;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.component.exec.PingCheckConfiguration;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.da.exec.configuration.ConfigurationFactory;
import org.eclipse.scada.da.exec.configuration.EnvEntryType;
import org.eclipse.scada.da.exec.configuration.HiveProcessCommandType;
import org.eclipse.scada.da.exec.configuration.ProcessType;
import org.eclipse.scada.da.exec.configuration.RootType;

class PingCheckWriter {
    private static final String ATTR_PING_CHECK_WRITER = "pingCheckWriter";
    private final Map<String, String> hostnameMap = new HashMap<String, String>();
    private final RootType root;
    private final PingCheckConfiguration cfg;

    public PingCheckWriter(PingCheckConfiguration cfg, RootType root) {
        this.cfg = cfg;
        this.root = root;
    }

    public void addEntry(String hostname, String alias) {
        this.hostnameMap.put(alias, hostname);
    }

    public void finish() {
        HiveProcessCommandType cmd = ConfigurationFactory.eINSTANCE.createHiveProcessCommandType();
        cmd.setId("PING");
        cmd.setRestartDelay(10000);
        cmd.setMaxInputBuffer(10000);
        ProcessType process = ConfigurationFactory.eINSTANCE.createProcessType();
        cmd.setProcess(process);
        if (this.cfg.getPingDelay() != null) {
            EnvEntryType env1 = ConfigurationFactory.eINSTANCE.createEnvEntryType();
            env1.setName("PING_PERIOD");
            env1.setValue(String.format("%s", this.cfg.getPingDelay()));
            process.getEnv().add((Object)env1);
        }
        process.setExec("eclipse_scada_ping");
        for (Map.Entry<String, String> entry : this.hostnameMap.entrySet()) {
            process.getArgument().add((Object)String.format("%s=%s", entry.getValue(), entry.getKey()));
        }
        this.root.getHiveProcess().add((Object)cmd);
    }

    public static PingCheckWriter find(PingCheckConfiguration cfg, RootType root, GeneratorContext context) {
        PingCheckWriter writer = (PingCheckWriter)context.getAttribute((Object)root, ATTR_PING_CHECK_WRITER);
        if (writer == null) {
            PingCheckWriter _writer;
            writer = _writer = new PingCheckWriter(cfg, root);
            context.setAttribute((Object)root, ATTR_PING_CHECK_WRITER, (Object)writer);
            context.addPostTrigger(new Runnable(){

                @Override
                public void run() {
                    PingCheckWriter.this.finish();
                }
            });
        }
        return writer;
    }
}

