/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.driver.parser.lib;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.scada.configuration.driver.parser.ParserDriver;
import org.eclipse.scada.configuration.world.lib.oscar.EquinoxApplicationProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.da.server.component.parser.factory.configuration.Component;

public class ParserDriverProcessor
extends EquinoxApplicationProcessor {
    private final ParserDriver driver;

    public ParserDriverProcessor(ParserDriver driver) {
        super((EquinoxApplication)driver);
        this.driver = driver;
    }

    protected void processForContext(OscarContext ctx, IFolder output, IProgressMonitor monitor) throws Exception {
        for (Component device : this.driver.getComponents()) {
            this.createComponent(ctx, device);
        }
    }

    private void createComponent(OscarContext ctx, Component component) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = component.getId();
        String xml = this.makeXml(component);
        data.put("configuration", xml);
        ctx.addData("org.eclipse.scada.da.server.component.parser.factory", id, data);
    }

    private String makeXml(Component component) throws IOException {
        XMIResourceImpl xmi = new XMIResourceImpl();
        xmi.getContents().add((Object)EcoreUtil.copy((EObject)component));
        StringWriter writer = new StringWriter();
        xmi.save((Writer)writer, null);
        return writer.toString();
    }
}

