/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.validation;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.lib.ExclusiveGroups;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;
import org.eclipse.scada.utils.ecore.validation.Validator;

public class ExclusiveGroupValidator
implements Validator,
IExecutableExtension {
    private String featureName;

    public void validate(ValidationContext context) {
        Object o = context.getTarget();
        if (!(o instanceof EObject)) {
            return;
        }
        EObject eo = (EObject)o;
        EStructuralFeature f = eo.eClass().getEStructuralFeature(this.featureName);
        if (f == null) {
            return;
        }
    }

    protected void validateExclusiveGroup(ValidationContext context, EList<? extends EObject> objects) {
        Map violations = ExclusiveGroups.validate(objects);
        for (Map.Entry entry : violations.entrySet()) {
            context.add(Severity.ERROR, new Object[]{entry.getValue()}, "Object belongs to an exclusive group ({0}), but actually found multiple instances for this group.", new Object[]{entry.getKey()});
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Object o;
        if (data instanceof String) {
            this.featureName = (String)data;
        } else if (data instanceof Map && (o = ((Map)data).get("feature")) instanceof String) {
            this.featureName = (String)o;
        }
    }
}

