/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.Container;
import org.eclipse.scada.configuration.component.lib.Components;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.Helper;
import org.eclipse.scada.configuration.component.lib.create.MasterItemCreatorImpl;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Driver;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.configuration.world.osgi.ValueArchiveServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemCreatorImpl
extends MasterItemCreatorImpl {
    private static final Logger logger = LoggerFactory.getLogger(ItemCreatorImpl.class);
    private final Component component;
    private final GeneratorContext ctx;

    public ItemCreatorImpl(GeneratorContext ctx, GeneratorContext.MasterContext master, Component component) {
        super(master, component, (Container)component.getLevel());
        this.ctx = ctx;
        this.component = component;
    }

    public CreationRequest<SourceItem> createSourceItem(final org.eclipse.scada.configuration.infrastructure.Driver source, String sourceName) {
        CreationRequest req = super.createSourceItem(source, sourceName);
        if (source != null) {
            req.addMasterListener((MasterListener)new MasterListener<SourceItem>(){

                public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                    ItemCreatorImpl.this.setDriverConnection(source, item, master);
                }
            });
        }
        return req;
    }

    public CreationRequest<SourceItem> createImportItem(final MasterImport masterImport, String sourceName) {
        CreationRequest req = super.createImportItem(masterImport, sourceName);
        req.addMasterListener((MasterListener)new MasterListener<SourceItem>(){

            public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                GeneratorContext.MasterContext importedMaster = ItemCreatorImpl.this.ctx.getMasterContext(masterImport.getImportedMaster());
                DataAccessConnection con = ItemCreatorImpl.findConnection(master.getImplementation(), importedMaster.getImplementation());
                if (con == null) {
                    throw new IllegalStateException(String.format("Unable to find DataAccess connection from %s to %s", master.getImplementation(), importedMaster.getImplementation()));
                }
                item.setConnection(con);
            }
        });
        return req;
    }

    private static DataAccessConnection findConnection(org.eclipse.scada.configuration.world.osgi.MasterServer from, org.eclipse.scada.configuration.world.osgi.MasterServer to) {
        for (Connection c : from.getConnections()) {
            if (!(c instanceof DataAccessConnection)) continue;
            for (Exporter e : to.getExporter()) {
                Endpoint ep = c.getMatchingEndpoint(e);
                if (ep == null) continue;
                return (DataAccessConnection)c;
            }
        }
        return null;
    }

    public <T extends Device> CreationRequest<SourceItem> createDeviceItem(final T device, String sourceName) {
        CreationRequest req = super.createDeviceItem(device, sourceName);
        req.addMasterListener((MasterListener)new MasterListener<SourceItem>(){

            public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                AbstractFactoryDriver driver = Helper.findDriverForDevice((MasterServer)master.getDefinition(), (Device)device);
                if (driver == null) {
                    throw new RuntimeException(String.format("Device '%s' does not belong to a driver that is assigned to master server %s", device, master.getDefinition()));
                }
                ItemCreatorImpl.this.setDriverConnection((org.eclipse.scada.configuration.infrastructure.Driver)driver, item, master);
            }
        });
        return req;
    }

    private void setDriverConnection(org.eclipse.scada.configuration.infrastructure.Driver source, SourceItem item, GeneratorContext.MasterContext master) {
        Driver driver = (Driver)this.ctx.getDriverMap().get(source);
        if (driver == null) {
            throw new IllegalStateException(String.format("Driver '%s' cannot be resolved.", source));
        }
        EList endpoints = driver.getEndpoints();
        Helper.setSourceConnectionFromEndpoints((SourceItem)item, (org.eclipse.scada.configuration.world.osgi.MasterServer)master.getImplementation(), (Collection)endpoints);
    }

    protected <T extends Item> void itemAdded(T item, CustomizationRequest customizationRequest, List<String> originalLocalTags, Set<MasterListener<T>> masterListeners) {
        super.itemAdded(item, customizationRequest, originalLocalTags, masterListeners);
        Items.registerMappedItem((GeneratorContext)this.ctx, (Component)this.component, originalLocalTags, item);
        if (this.isArchive(item, customizationRequest)) {
            logger.debug("Archive item: {}", item);
            ValueArchiveServer archive = this.ctx.getArchiveServer(this.master.getImplementation());
            if (archive == null) {
                Node node = Nodes.fromApp((Application)this.master.getImplementation());
                throw new IllegalStateException(String.format("Item %s should be archived but no archive server is configured for %s on %s", item, this.master, node));
            }
            org.eclipse.scada.configuration.lib.Items.addArchive((ValueArchiveServer)archive, item);
        }
    }

    protected void customizeItem(Item item, CustomizationRequest customizationRequest) {
        Components.customizeItem((Component)this.component, (Item)item, (CustomizationRequest)customizationRequest);
    }

    protected boolean isArchive(Item item, CustomizationRequest customizationRequest) {
        return Components.isArchived((Component)this.component, (Item)item, (CustomizationRequest)customizationRequest);
    }
}

