/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.configuration.component.CalculationModule;
import org.eclipse.scada.configuration.component.InputDefinition;
import org.eclipse.scada.configuration.component.OutputDefinition;
import org.eclipse.scada.configuration.component.OutputSpecification;

public final class Calculations {
    private Calculations() {
    }

    public static OutputDefinition findSingleByName(Collection<OutputDefinition> defs, String name) {
        for (OutputDefinition def : defs) {
            if (!name.equals(def.getName())) continue;
            return def;
        }
        throw new IllegalArgumentException(String.format("Unable to find an output named '%s'", name));
    }

    public static InputDefinition findSingleInputByName(Collection<InputDefinition> defs, String name) {
        for (InputDefinition def : defs) {
            if (!name.equals(def.getName())) continue;
            return def;
        }
        throw new IllegalArgumentException(String.format("Unable to find an input named '%s'", name));
    }

    public static List<InputDefinition> findByName(Collection<InputDefinition> defs, String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        LinkedList<InputDefinition> result = new LinkedList<InputDefinition>();
        for (InputDefinition def : defs) {
            if (!name.equals(def.getName())) continue;
            result.add(def);
        }
        return result;
    }

    public static OutputSpecification findSpecification(CalculationModule implementation, OutputDefinition output) {
        for (OutputSpecification spec : implementation.getKnownOutputs()) {
            if (spec.getName() == null || !spec.getName().equals(output.getName())) continue;
            return spec;
        }
        return null;
    }
}

