/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.CalculationComponent;
import org.eclipse.scada.configuration.component.CalculationModule;
import org.eclipse.scada.configuration.component.FormulaModule;
import org.eclipse.scada.configuration.component.InputDefinition;
import org.eclipse.scada.configuration.component.OutputDefinition;
import org.eclipse.scada.configuration.component.OutputSpecification;
import org.eclipse.scada.configuration.component.Script;
import org.eclipse.scada.configuration.component.generator.calc.CalculationComponentGenerator;
import org.eclipse.scada.configuration.component.generator.calc.Calculations;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.FormulaItem;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.TypedItemReference;

public class FormulaModuleGenerator
extends CalculationComponentGenerator<FormulaModule> {
    private final Map<MasterServer, FormulaItem> danglingMap = new HashMap<MasterServer, FormulaItem>();

    public FormulaModuleGenerator(CalculationComponent calculationComponent) {
        super(calculationComponent, FormulaModule.class);
    }

    public CreationRequest<FormulaItem> createFormulaItem(ItemCreator creator) {
        FormulaItem formulaItem = OsgiFactory.eINSTANCE.createFormulaItem();
        return creator.addItem((Item)formulaItem);
    }

    @Override
    protected void createItems(ItemCreator creator, FormulaModule implementation) {
        OutputDefinition output = Calculations.findSingleByName((Collection<OutputDefinition>)this.calculationComponent.getOutputs(), "output");
        OutputSpecification outputSpec = Calculations.findSpecification((CalculationModule)implementation, output);
        if (outputSpec == null) {
            throw new IllegalStateException(String.format("Output specification '%s' not found on module '%s'", output.getName(), implementation.getName()));
        }
        CreationRequest<FormulaItem> c = this.createFormulaItem(creator);
        c.dataType(outputSpec.getDataType());
        c.customizationTags((Collection)output.getCustomizationTags());
        c.localTags((Collection)output.getLocalTag());
        c.addMasterListener((MasterListener)new MasterListener<FormulaItem>(){

            public void setMaster(FormulaItem item, GeneratorContext.MasterContext master) {
                FormulaModuleGenerator.this.danglingMap.put(master.getImplementation(), item);
            }
        });
        FormulaItem item = (FormulaItem)c.create();
        item.setScriptEngine(implementation.getScriptEngine());
        item.setInbound(OsgiFactory.eINSTANCE.createFormulaItemInbound());
        for (Script script : implementation.getInit()) {
            CodeFragment code = OsgiFactory.eINSTANCE.createCodeFragment();
            code.setCode(script.getCode());
            item.getInitScripts().add((Object)code);
        }
        if (implementation.getUpdate() != null) {
            item.getInbound().setInputFormula(implementation.getUpdate().getCode());
        }
        item.getInitProperties().addAll(EcoreUtil.copyAll((Collection)this.calculationComponent.getInitProperties()));
        for (InputDefinition input : this.calculationComponent.getInputs()) {
            TypedItemReference typedRef = OsgiFactory.eINSTANCE.createTypedItemReference();
            typedRef.setItem((Item)input.createReference());
            typedRef.setName(input.getName());
            typedRef.setType(DataType.VARIANT);
            item.getInbound().getInputs().add((Object)typedRef);
        }
    }

    @Override
    public boolean supportsInitProperties() {
        return true;
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master, FormulaModule implementation) {
    }

    @Override
    public void finish(FinishContext context) {
        super.finish(context);
        for (Map.Entry<MasterServer, FormulaItem> entry : this.danglingMap.entrySet()) {
            MasterServer master = entry.getKey();
            FormulaItem formulaItem = entry.getValue();
            if (formulaItem.getInbound() == null) continue;
            for (TypedItemReference in : formulaItem.getInbound().getInputs()) {
                in.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)in.getItem()));
            }
        }
    }
}

