/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.calc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.CalculationComponent;
import org.eclipse.scada.configuration.component.CalculationModule;
import org.eclipse.scada.configuration.component.InputDefinition;
import org.eclipse.scada.configuration.component.OutputDefinition;
import org.eclipse.scada.configuration.component.OutputSpecification;
import org.eclipse.scada.configuration.component.Script;
import org.eclipse.scada.configuration.component.ScriptModule;
import org.eclipse.scada.configuration.component.generator.calc.CalculationComponentGenerator;
import org.eclipse.scada.configuration.component.generator.calc.Calculations;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;

public class ScriptModuleGenerator
extends CalculationComponentGenerator<ScriptModule> {
    private final Map<MasterServer, ScriptItem> danglingMap = new HashMap<MasterServer, ScriptItem>();

    public ScriptModuleGenerator(CalculationComponent calculationComponent) {
        super(calculationComponent, ScriptModule.class);
    }

    public CreationRequest<ScriptItem> createScriptItem(ItemCreator creator) {
        ScriptItem item = OsgiFactory.eINSTANCE.createScriptItem();
        return creator.addItem((Item)item);
    }

    @Override
    protected void createItems(ItemCreator creator, ScriptModule implementation) {
        ItemReference itemRef;
        OutputDefinition output = Calculations.findSingleByName((Collection<OutputDefinition>)this.calculationComponent.getOutputs(), "output");
        OutputSpecification outputSpec = Calculations.findSpecification((CalculationModule)implementation, output);
        if (outputSpec == null) {
            throw new IllegalStateException(String.format("Output specification '%s' not found on module '%s'", output.getName(), implementation.getName()));
        }
        CreationRequest<ScriptItem> c = this.createScriptItem(creator);
        c.localTags((Collection)output.getLocalTag());
        c.customizationTags((Collection)output.getCustomizationTags());
        c.dataType(outputSpec.getDataType());
        c.addMasterListener((MasterListener)new MasterListener<ScriptItem>(){

            public void setMaster(ScriptItem item, GeneratorContext.MasterContext master) {
                ScriptModuleGenerator.this.danglingMap.put(master.getImplementation(), item);
            }
        });
        ScriptItem item = (ScriptItem)c.create();
        item.setScriptEngine(implementation.getScriptEngine());
        item.setInitScript(this.toCodeFragment(implementation.getInitScript()));
        item.setUpdateScript(this.toCodeFragment(implementation.getUpdateScript()));
        item.setWriteCommandScript(this.toCodeFragment(implementation.getWriteCommandScript()));
        if (implementation.getTimerScript() != null) {
            item.setTimer(OsgiFactory.eINSTANCE.createScriptTimer());
            item.getTimer().setScript(OsgiFactory.eINSTANCE.createCodeFragment());
            item.getTimer().getScript().setCode(implementation.getTimerScript().getCode());
            item.getTimer().setPeriod(implementation.getTimerScript().getPeriod());
        }
        for (InputDefinition input : this.calculationComponent.getInputs()) {
            itemRef = OsgiFactory.eINSTANCE.createItemReference();
            itemRef.setItem((Item)input.createReference());
            itemRef.setName(input.getName());
            item.getInputs().add((Object)itemRef);
        }
        item.getInitProperties().addAll(EcoreUtil.copyAll((Collection)this.calculationComponent.getInitProperties()));
        for (OutputDefinition outputDef : this.calculationComponent.getOutputs()) {
            if ("output".equals(outputDef.getName())) continue;
            itemRef = OsgiFactory.eINSTANCE.createItemReference();
            itemRef.setItem((Item)outputDef.createReference());
            itemRef.setName(outputDef.getName());
            item.getCommands().add((Object)itemRef);
        }
    }

    @Override
    public boolean supportsInitProperties() {
        return true;
    }

    private CodeFragment toCodeFragment(Script initScript) {
        if (initScript == null) {
            return null;
        }
        CodeFragment codeFragment = OsgiFactory.eINSTANCE.createCodeFragment();
        codeFragment.setCode(initScript.getCode());
        return codeFragment;
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master, ScriptModule implementation) {
    }

    @Override
    public void finish(FinishContext context) {
        super.finish(context);
        for (Map.Entry<MasterServer, ScriptItem> entry : this.danglingMap.entrySet()) {
            MasterServer master = entry.getKey();
            ScriptItem item = entry.getValue();
            for (ItemReference input : item.getInputs()) {
                input.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)input.getItem()));
            }
            for (ItemReference command : item.getCommands()) {
                command.setItem(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master, (Item)command.getItem()));
            }
        }
    }
}

