/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.mapper;

import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.DataMapperAnalyzer;
import org.eclipse.scada.configuration.component.DataMapperService;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.osgi.DataMapper;

public class DataMapperAnalyzerGenerator
extends DataComponentGenerator {
    private final DataMapperAnalyzer dataMapperAnalyzer;

    public DataMapperAnalyzerGenerator(DataMapperAnalyzer dataMapper) {
        super((DataComponent)dataMapper);
        this.dataMapperAnalyzer = dataMapper;
    }

    @Override
    public void createItems(ItemCreator itemCreator) {
        itemCreator.markUnsupported();
    }

    @Override
    protected void generateForMaster(GenerationContext context, GeneratorContext.MasterContext master) {
        DataMapperService dataMapper = this.dataMapperAnalyzer.getDataMapper();
        if (!dataMapper.getMasterOn().contains((Object)master)) {
            throw new IllegalStateException(String.format("%s must run on a master server that also runs the data mapper", DataMapperAnalyzer.class.getName()));
        }
        String prefix = Names.makeName((NamedDocumentable)((NamedDocumentable)context.requestMapping((Object)dataMapper, DataMapper.class)));
        ItemCreator creator = this.createItemCreator(master);
        CreationRequest c = creator.createSelfItem(String.valueOf(prefix) + ".entries");
        c.localTags(new String[]{"NUM"}).customizationTags(new String[]{"analog", "input"});
        c.information("Number of entries in data mapper", null, null);
        c.create();
        c = creator.createSelfItem(String.valueOf(prefix) + ".entries");
        c.localTags(new String[]{"ERR"}).customizationTags(new String[]{"digital", "input"});
        c.information("Data loading error", null, null);
        c.create();
        c = creator.createSelfItem(String.valueOf(prefix) + ".entries");
        c.localTags(new String[]{"LOADING"}).customizationTags(new String[]{"digital", "input"});
        c.information("Loading data", null, null);
        c.create();
        c = creator.createSelfItem(String.valueOf(prefix) + ".entries");
        c.localTags(new String[]{"RELOAD"}).customizationTags(new String[]{"command"});
        c.information("Perform reload", null, null);
        c.create();
    }
}

