/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.ca.oscar.OscarLoader;
import org.eclipse.scada.configuration.generator.ui.AbstractFileRunner;
import org.eclipse.scada.configuration.world.lib.validator.LoopValidator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;

public class OscarValidatorHandler
extends AbstractFileRunner {
    @Override
    protected void runFile(IFile file, IProgressMonitor monitor) throws Exception {
        Map data;
        MessageConsole mc = new MessageConsole(String.format("OSCAR Validation: %s", file), "org.eclipse.scada.configuration.oscar.validation", null, true);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{mc});
        mc.activate();
        File dataFile = file.getLocation().toFile();
        if (OscarLoader.isOscar((File)dataFile)) {
            data = new OscarLoader(dataFile).getData();
        } else {
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileInputStream stream = new FileInputStream(dataFile);){
                data = OscarLoader.loadJsonData((InputStream)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        try (PrintStream consoleStream = new PrintStream((OutputStream)mc.newOutputStream());){
            new LoopValidator(data, consoleStream).validate();
        }
    }
}

