/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.common.lib;

import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.common.HeartbeatGenerator;
import org.eclipse.scada.configuration.component.common.lib.Helper;
import org.eclipse.scada.configuration.component.generator.AbstractDanglingGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.ScriptTimer;

public class ToggleHeartbeatGeneratorGenerator
extends AbstractDanglingGenerator {
    private final HeartbeatGenerator generator;

    public ToggleHeartbeatGeneratorGenerator(HeartbeatGenerator generator) {
        super((DataComponent)generator);
        this.generator = generator;
    }

    public void createItems(ItemCreator itemCreator) {
        ScriptItem item = OsgiFactory.eINSTANCE.createScriptItem();
        CodeFragment initCode = this.makeInitCode();
        CodeFragment timerCode = this.makeTimerCode();
        CodeFragment updateCode = this.makeUpdateCode();
        if (this.generator.getTargetItem() != null) {
            ItemReference ref = OsgiFactory.eINSTANCE.createItemReference();
            ref.setName("A");
            ref.setItem((Item)this.generator.getTargetItem().createReference());
            item.getCommands().add((Object)ref);
        }
        if (this.generator.getActiveInput() != null) {
            ItemReference activeRef = OsgiFactory.eINSTANCE.createItemReference();
            activeRef.setName("INPUT");
            activeRef.setItem((Item)this.generator.getActiveInput().createReference());
            item.getInputs().add((Object)activeRef);
        }
        ScriptTimer timer = OsgiFactory.eINSTANCE.createScriptTimer();
        timer.setPeriod(this.generator.getPeriod());
        timer.setScript(timerCode);
        item.setInitScript(initCode);
        item.setUpdateScript(updateCode);
        item.setTimer(timer);
        CreationRequest req = itemCreator.addItem((Item)item);
        req.localTags(new String[]{"STATE"});
        req.dataType(DataType.BOOLEAN);
        req.customizationTags(new String[]{"input"});
        req.information("Heartbeat state", null, null);
        this.createScriptItem(req);
    }

    private CodeFragment makeCode(StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        CodeFragment code = OsgiFactory.eINSTANCE.createCodeFragment();
        code.setCode(sb.toString());
        return code;
    }

    private CodeFragment makeUpdateCode() {
        if (this.generator.getActiveInput() == null) {
            return null;
        }
        String codeString = Helper.loadResource("toggle.generator.active.update.js");
        CodeFragment code = OsgiFactory.eINSTANCE.createCodeFragment();
        code.setCode(codeString);
        return code;
    }

    private CodeFragment makeTimerCode() {
        StringBuilder sb = new StringBuilder();
        if (this.generator.getActiveInput() != null) {
            sb.append("if ( active ) { state = !state; write(); }");
            sb.append("currentState();");
        } else {
            sb.append("state = !state; write(); state;");
        }
        return this.makeCode(sb);
    }

    private CodeFragment makeInitCode() {
        StringBuilder sb = new StringBuilder();
        if (this.generator.getTargetItem() != null) {
            sb.append("function write () { writer.write(\"A\", state ); }");
        } else {
            sb.append("function write () {}");
        }
        if (this.generator.getActiveInput() != null) {
            sb.append(Helper.loadResource("toggle.generator.active.init.js"));
        }
        sb.append("var state = true;");
        return this.makeCode(sb);
    }
}

