/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.deployment;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StartupMechanism implements Enumerator
{
    DEFAULT(0, "DEFAULT", "DEFAULT"),
    UPSTART(1, "UPSTART", "UPSTART"),
    REDHAT_SYSV(2, "REDHAT_SYSV", "REDHAT_SYSV"),
    LSB_SYSV(3, "LSB_SYSV", "LSB_SYSV"),
    SYSTEMD(4, "SYSTEMD", "SYSTEMD");

    public static final int DEFAULT_VALUE = 0;
    public static final int UPSTART_VALUE = 1;
    public static final int REDHAT_SYSV_VALUE = 2;
    public static final int LSB_SYSV_VALUE = 3;
    public static final int SYSTEMD_VALUE = 4;
    private static final StartupMechanism[] VALUES_ARRAY;
    public static final List<StartupMechanism> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StartupMechanism[]{DEFAULT, UPSTART, REDHAT_SYSV, LSB_SYSV, SYSTEMD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StartupMechanism get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StartupMechanism result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StartupMechanism getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StartupMechanism result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StartupMechanism get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return UPSTART;
            }
            case 2: {
                return REDHAT_SYSV;
            }
            case 3: {
                return LSB_SYSV;
            }
            case 4: {
                return SYSTEMD;
            }
        }
        return null;
    }

    private StartupMechanism(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

