/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PasswordType implements Enumerator
{
    PLAIN(0, "PLAIN", "PLAIN"),
    PLAIN_IGNORE_CASE(1, "PLAIN_IGNORE_CASE", "PLAIN_IGNORE_CASE"),
    MD5_HEX(2, "MD5_HEX", "MD5_HEX"),
    SHA1_HEX(3, "SHA1_HEX", "SHA1_HEX");

    public static final int PLAIN_VALUE = 0;
    public static final int PLAIN_IGNORE_CASE_VALUE = 1;
    public static final int MD5_HEX_VALUE = 2;
    public static final int SHA1_HEX_VALUE = 3;
    private static final PasswordType[] VALUES_ARRAY;
    public static final List<PasswordType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PasswordType[]{PLAIN, PLAIN_IGNORE_CASE, MD5_HEX, SHA1_HEX};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PasswordType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PasswordType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PasswordType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PasswordType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PasswordType get(int value) {
        switch (value) {
            case 0: {
                return PLAIN;
            }
            case 1: {
                return PLAIN_IGNORE_CASE;
            }
            case 2: {
                return MD5_HEX;
            }
            case 3: {
                return SHA1_HEX;
            }
        }
        return null;
    }

    private PasswordType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

