/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReplicationDataFormat implements Enumerator
{
    BLOB(0, "BLOB", "BLOB"),
    BYTES(1, "BYTES", "BYTES"),
    JSON(2, "JSON", "JSON"),
    ARRAY(3, "ARRAY", "ARRAY");

    public static final int BLOB_VALUE = 0;
    public static final int BYTES_VALUE = 1;
    public static final int JSON_VALUE = 2;
    public static final int ARRAY_VALUE = 3;
    private static final ReplicationDataFormat[] VALUES_ARRAY;
    public static final List<ReplicationDataFormat> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReplicationDataFormat[]{BLOB, BYTES, JSON, ARRAY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReplicationDataFormat get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReplicationDataFormat result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReplicationDataFormat getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReplicationDataFormat result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReplicationDataFormat get(int value) {
        switch (value) {
            case 0: {
                return BLOB;
            }
            case 1: {
                return BYTES;
            }
            case 2: {
                return JSON;
            }
            case 3: {
                return ARRAY;
            }
        }
        return null;
    }

    private ReplicationDataFormat(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

