/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RoundingType implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    ROUND(1, "ROUND", "ROUND"),
    CEIL(2, "CEIL", "CEIL"),
    FLOOR(3, "FLOOR", "FLOOR");

    public static final int NONE_VALUE = 0;
    public static final int ROUND_VALUE = 1;
    public static final int CEIL_VALUE = 2;
    public static final int FLOOR_VALUE = 3;
    private static final RoundingType[] VALUES_ARRAY;
    public static final List<RoundingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RoundingType[]{NONE, ROUND, CEIL, FLOOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RoundingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoundingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoundingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoundingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoundingType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return ROUND;
            }
            case 2: {
                return CEIL;
            }
            case 3: {
                return FLOOR;
            }
        }
        return null;
    }

    private RoundingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

