/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scada.configuration.component.DanglingItemReference;
import org.eclipse.scada.configuration.component.lib.Activator;
import org.eclipse.scada.configuration.component.lib.DanglingReferenceResolver;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingDanglingReferenceResolver
implements DanglingReferenceResolver,
IRegistryEventListener {
    private static final Logger logger = LoggerFactory.getLogger(ForwardingDanglingReferenceResolver.class);
    private static final String ATTR_CLASS = "class";
    private static final String EXPT_DANGLING_RESOLVER = "org.eclipse.scada.configuration.component.lib.generation";
    private static final Object ELE_RESOLVER = "resolver";
    private final Set<DanglingReferenceResolver> cache = new HashSet<DanglingReferenceResolver>();

    public ForwardingDanglingReferenceResolver() {
        Platform.getExtensionRegistry().addListener((IRegistryEventListener)this, EXPT_DANGLING_RESOLVER);
        this.buildCache();
    }

    private void buildCache() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPT_DANGLING_RESOLVER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ele.getName().equals(ELE_RESOLVER)) {
                try {
                    DanglingReferenceResolver resolver = (DanglingReferenceResolver)ele.createExecutableExtension(ATTR_CLASS);
                    logger.debug("Adding resolver: {}", (Object)resolver);
                    this.cache.add(resolver);
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scada.configuration.component.lib", "Failed to create resolver instance", (Throwable)e));
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this);
    }

    @Override
    public Item resolveReference(GeneratorContext ctx, MasterServer master, DanglingItemReference ref) {
        for (DanglingReferenceResolver resolver : this.cache) {
            Item result = resolver.resolveReference(ctx, master, ref);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void added(IExtension[] extensions) {
        this.buildCache();
    }

    public void removed(IExtension[] extensions) {
        this.buildCache();
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.buildCache();
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.buildCache();
    }
}

