/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.DanglingItemReference;
import org.eclipse.scada.configuration.component.lib.Activator;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Items {
    private static final String ATTR_LOCAL_TAG_MAP = "localTagMap";
    private static final Logger logger = LoggerFactory.getLogger(Items.class);

    public static Item findMasterItem(MasterServer master, String name) {
        for (Item item : master.getItems()) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public static Item replaceDanglingReference(GeneratorContext ctx, MasterServer master, Item item) {
        if (!(item instanceof DanglingItemReference)) {
            return item;
        }
        DanglingItemReference dref = (DanglingItemReference)item;
        Item replacement = Activator.getDefault().getResolver().resolveReference(ctx, master, dref);
        if (replacement == null) {
            throw new IllegalStateException(String.format("Unable to find item for dangling reference: %s on %s", item, master));
        }
        logger.debug("Replacing item - {} -> {}", (Object)item, (Object)replacement);
        return replacement;
    }

    public static void replaceDanglingReferences(GeneratorContext ctx, MasterServer master, EList<Item> sourceItems) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (Item item : sourceItems) {
            items.add(Items.replaceDanglingReference(ctx, master, item));
        }
        ECollections.setEList(sourceItems, items);
    }

    public static void registerMappedItem(GeneratorContext ctx, Component component, List<String> originalLocalTags, Item item) {
        if (component == null) {
            return;
        }
        HashMap<List<String>, Item> tagMap = (HashMap<List<String>, Item>)ctx.getAttribute((Object)component, ATTR_LOCAL_TAG_MAP);
        if (tagMap == null) {
            tagMap = new HashMap<List<String>, Item>();
            ctx.setAttribute((Object)component, ATTR_LOCAL_TAG_MAP, tagMap);
        }
        tagMap.put(originalLocalTags, item);
    }

    public static Item findMappedItem(GeneratorContext ctx, Component component, List<String> localTags) {
        Map tagMap = (Map)ctx.getAttribute((Object)component, ATTR_LOCAL_TAG_MAP);
        if (tagMap == null) {
            return null;
        }
        logger.debug("Mapped content: {}", (Object)tagMap);
        return (Item)tagMap.get(localTags);
    }

    public static Item getMappedItem(GeneratorContext ctx, Component component, List<String> localTags) {
        Item item = Items.findMappedItem(ctx, component, localTags);
        if (item == null) {
            throw new IllegalStateException(String.format("Unable to find item for local tag %s on component %s", localTags, component));
        }
        return item;
    }
}

