/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.lib.Components;
import org.eclipse.scada.configuration.component.lib.create.AbstractComponentItemCreator;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureItemCreator
extends AbstractComponentItemCreator {
    private static final Logger logger = LoggerFactory.getLogger(CaptureItemCreator.class);
    private final Map<List<String>, ItemCreation> entries;

    public CaptureItemCreator(Component component, Map<List<String>, ItemCreation> entries) {
        super(component);
        this.entries = entries;
    }

    @Override
    public void createMarker(IStatus status) {
    }

    @Override
    protected <T extends Item> void itemAdded(T item, CustomizationRequest customizationRequest, List<String> originalLocalTags, Set<MasterListener<T>> masterListeners) {
        logger.debug("Adding item: {}", item);
        this.entries.put(new ArrayList<String>(originalLocalTags), new ItemCreation(item, customizationRequest));
    }

    @Override
    protected void customizeItem(Item item, CustomizationRequest customizationRequest) {
        Components.customizeItem(this.component, item, customizationRequest);
    }

    public static class ItemCreation {
        private final Item item;
        private final CustomizationRequest customizationRequest;

        public ItemCreation(Item item, CustomizationRequest customizationRequest) {
            this.item = item;
            this.customizationRequest = customizationRequest;
        }

        public Item getItem() {
            return this.item;
        }

        public CustomizationRequest getCustomizationRequest() {
            return this.customizationRequest;
        }
    }
}

