/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.Container;
import org.eclipse.scada.configuration.component.ItemInterceptor;
import org.eclipse.scada.configuration.component.lib.ItemInterceptorHandler;
import org.eclipse.scada.configuration.component.lib.create.AbstractComponentItemCreator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.Helper;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.lib.Items;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.world.PropertyEntry;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;

public abstract class MasterItemCreatorImpl
extends AbstractComponentItemCreator {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    protected final GeneratorContext.MasterContext master;
    private final Container container;
    private final Properties properties;

    public MasterItemCreatorImpl(GeneratorContext.MasterContext master, Component component, Container container) {
        super(component);
        this.master = master;
        this.container = container;
        this.properties = MasterItemCreatorImpl.createProperties(component);
    }

    private static Properties createProperties(Component component) {
        if (component == null) {
            return EMPTY_PROPERTIES;
        }
        Properties parentProperties = MasterItemCreatorImpl.createProperties((Container)component.getLevel());
        if (component.getProperties().isEmpty()) {
            return parentProperties == null ? EMPTY_PROPERTIES : parentProperties;
        }
        Properties p = parentProperties != null ? new Properties(parentProperties) : new Properties();
        MasterItemCreatorImpl.fillProperties(p, (EList<PropertyEntry>)component.getProperties());
        return p;
    }

    private static Properties createProperties(Container container) {
        if (container == null) {
            return null;
        }
        Properties parentProperties = MasterItemCreatorImpl.createProperties((Container)AdapterHelper.adapt((Object)container.eContainer(), Container.class));
        if (container.getProperties().isEmpty()) {
            return parentProperties;
        }
        Properties p = parentProperties != null ? new Properties(parentProperties) : new Properties();
        MasterItemCreatorImpl.fillProperties(p, (EList<PropertyEntry>)container.getProperties());
        return p;
    }

    private static void fillProperties(Properties properties, EList<PropertyEntry> entries) {
        for (PropertyEntry pe : entries) {
            properties.put(pe.getKey(), pe.getValue());
        }
    }

    @Override
    public CreationRequest<SourceItem> createSelfItem(String sourceName) {
        CreationRequest<SourceItem> req = this.createSourceItem(null, sourceName);
        req.addMasterListener(new MasterListener<SourceItem>(){

            @Override
            public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                Helper.setSourceConnectionFromEndpoints(item, master.getImplementation(), Locator.getSelfEndpoints((MasterServer)master.getImplementation()));
            }
        });
        return req;
    }

    @Override
    public void createMarker(IStatus status) {
    }

    @Override
    protected <T extends Item> void itemAdded(T item, CustomizationRequest customizationRequest, List<String> originalLocalTags, Set<MasterListener<T>> masterListeners) {
        Items.addItem((MasterServer)this.master.getImplementation(), item);
        for (MasterListener<T> listener : masterListeners) {
            listener.setMaster(item, this.master);
        }
        this.callAllInterceptors(item);
    }

    private <T extends Item> void callAllInterceptors(T item) {
        Object c = this.container;
        while (c != null) {
            this.callItemInterceptors(item, (List<ItemInterceptor>)c.getItemInterceptors(), this.master);
            c = c.eContainer() instanceof Container ? (Container)c.eContainer() : null;
        }
    }

    protected void callItemInterceptors(Item item, List<ItemInterceptor> itemInterceptors, GeneratorContext.MasterContext masterContext) {
        for (ItemInterceptor i : itemInterceptors) {
            Properties p;
            ItemInterceptorHandler handler = (ItemInterceptorHandler)AdapterHelper.adapt((Object)i, ItemInterceptorHandler.class, (boolean)true);
            if (handler == null) {
                throw new IllegalStateException(String.format("Interceptor '%s' does not adapt to '%s'", i.eClass().getName(), ItemInterceptorHandler.class.getName()));
            }
            if (i.getProperties().isEmpty()) {
                p = this.properties;
            } else {
                p = new Properties(this.properties);
                MasterItemCreatorImpl.fillProperties(p, (EList<PropertyEntry>)i.getProperties());
            }
            handler.interceptItem(item, i, masterContext, p);
        }
    }
}

