/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.dave.lib;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scada.configuration.dave.DaveBlockDefinition;
import org.eclipse.scada.configuration.dave.DaveCommunicationProcessor;
import org.eclipse.scada.configuration.dave.DaveDevice;
import org.eclipse.scada.configuration.dave.DaveDriver;
import org.eclipse.scada.configuration.dave.DaveFactory;
import org.eclipse.scada.configuration.dave.DaveHelper;
import org.eclipse.scada.configuration.dave.DaveRequestBlock;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.lib.AbstractEquinoxDriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DeviceTypeValidator;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.memory.TypeDefinition;
import org.eclipse.scada.configuration.memory.TypeHelper;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerFactory;
import org.eclipse.scada.configuration.memory.manager.MemoryManagerModule;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class DriverFactoryImpl
extends AbstractEquinoxDriverFactory<DaveDriver> {
    private static final int MAX_REQUEST_SIZE = 220;
    private static final int MAX_AREA = 255;
    private static final int MAX_BLOCK = 65535;
    private static final int MAX_OFFSET = 65535;

    public DriverFactoryImpl() {
        this.addValidator((DriverValidator)new DeviceTypeValidator(DaveDevice.class));
    }

    protected DaveDriver createDriver() {
        return DaveFactory.eINSTANCE.createDaveDriver();
    }

    protected void configureDriver(AbstractFactoryDriver driver, DaveDriver result, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        MemoryManagerModule manager = MemoryManagerFactory.eINSTANCE.createMemoryManagerModule();
        result.getModules().add((Object)manager);
        for (Device device : driver.getDevices()) {
            if (!(device instanceof DaveDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            if (manager.getTypeSystem() == null) {
                manager.setTypeSystem(((DaveDevice)device).getTypeSystem());
            } else if (((DaveDevice)device).getTypeSystem() != null && manager.getTypeSystem().getName().equals(((DaveDevice)device).getTypeSystem().getName())) {
                throw new IllegalStateException("All S7 devices must share the same type system");
            }
            this.createDevice(driver, result, (DaveDevice)device, nodes);
        }
    }

    protected void createDevice(AbstractFactoryDriver driver, DaveDriver result, DaveDevice device, Map<org.eclipse.scada.configuration.infrastructure.Node, Node> nodes) {
        DaveCommunicationProcessor cp = DaveFactory.eINSTANCE.createDaveCommunicationProcessor();
        cp.setId(device.getName());
        cp.setRack((int)device.getRack());
        cp.setSlot((int)device.getSlot());
        cp.setReadTimeout(device.getReadTimeout());
        result.getDevices().add((Object)cp);
        Endpoint ep = Endpoints.registerEndpoint((Node)nodes.get(device.getNode()), (int)device.getPort(), null, (String)"S7 Device Endpoint");
        cp.setEndpoint(ep);
        HashMap<String, Integer> blockCounters = new HashMap<String, Integer>();
        for (DaveBlockDefinition blockDef : device.getBlocks()) {
            DaveRequestBlock blockReq = DaveFactory.eINSTANCE.createDaveRequestBlock();
            String name = DaveHelper.makeBlockName((DaveBlockDefinition)blockDef);
            Integer num = (Integer)blockCounters.get(name);
            num = num == null ? 1 : num + 1;
            blockCounters.put(name, num);
            blockReq.setName(name);
            blockReq.setId(String.format("%s_%s.%s", device.getName(), name, num));
            blockReq.setArea(blockDef.getArea());
            blockReq.setBlock(blockDef.getBlock());
            blockReq.setEnableStatistics(blockDef.isEnableStatistics());
            blockReq.setOffset(blockDef.getOffset());
            blockReq.setLength(TypeHelper.calculateByteSize((TypeDefinition)blockDef.getType()));
            blockReq.setPeriod(blockDef.getPeriod());
            blockReq.setType(blockDef.getType());
            blockReq.setDevice(cp);
            cp.getBlocks().add((Object)blockReq);
        }
    }

    protected void performValidation(ValidationContext ctx, EquinoxDriver driver) {
        super.performValidation(ctx, driver);
        HashSet<TypeSystem> typeSystems = new HashSet<TypeSystem>();
        for (Device device : driver.getDevices()) {
            if (!(device instanceof DaveDevice)) {
                throw new IllegalStateException(String.format("Device type %s is not supported", device.getClass()));
            }
            typeSystems.add(((DaveDevice)device).getTypeSystem());
            this.validateDevice(ctx, driver, (DaveDevice)device);
        }
        if (typeSystems.size() > 1) {
            ctx.add("All S7 devices of one driver instance must share the same type system ({0})", new Object[]{typeSystems});
        }
    }

    private void validateDevice(ValidationContext ctx, EquinoxDriver driver, DaveDevice device) {
        if (device.getName() == null || device.getName().isEmpty()) {
            ctx.add(Severity.ERROR, new Object[]{device}, "'Name' must not be empty", new Object[0]);
        }
        for (DaveBlockDefinition block : device.getBlocks()) {
            int len;
            if (block.getArea() < 0 || block.getArea() > 255) {
                ctx.add(Severity.ERROR, new Object[]{block}, "Area must be between [0..{0}]", new Object[]{255});
            }
            if (block.getBlock() < 0 || block.getBlock() > 65535) {
                ctx.add(Severity.ERROR, new Object[]{block}, "Block must be between [0..{0}]", new Object[]{65535});
            }
            if (block.getOffset() < 0 || block.getOffset() > 65535) {
                ctx.add(Severity.ERROR, new Object[]{block}, "Offset must be between [0..{0}]", new Object[]{65535});
            }
            if (block.getPeriod() < 0) {
                ctx.add(Severity.ERROR, new Object[]{block}, "Period must be positive", new Object[0]);
            }
            if ((len = TypeHelper.calculateByteSize((TypeDefinition)block.getType())) <= 220) continue;
            ctx.add(Severity.ERROR, new Object[]{block}, "Block size ({0}) is greater then the maxmimum request size ({1}). You will need to split up your type definition to reduce block size.", new Object[]{len, 220});
        }
    }
}

