/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.lib.internal;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.recipe.CaptureOutput;
import org.eclipse.scada.configuration.recipe.Execute;
import org.eclipse.scada.configuration.recipe.InputReference;
import org.eclipse.scada.configuration.recipe.InputValue;
import org.eclipse.scada.configuration.recipe.MapInput;
import org.eclipse.scada.configuration.recipe.lib.Executable;
import org.eclipse.scada.configuration.recipe.lib.ExecutableFactory;
import org.eclipse.scada.configuration.recipe.lib.Output;
import org.eclipse.scada.configuration.recipe.lib.internal.RunnerContext;
import org.eclipse.scada.utils.inject.InjectHelper;
import org.eclipse.scada.utils.inject.Optional;
import org.eclipse.scada.utils.reflect.Reflections;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutableFactory
implements ExecutableFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExecutableFactory.class);

    @Override
    public Executable create(Execute execute, RunnerContext ctx) {
        if (execute == null) {
            return null;
        }
        String name = execute.getName();
        Executable exec = this.lookupByUri(name, execute, ctx);
        if (exec != null) {
            return exec;
        }
        throw new IllegalArgumentException(String.format("Executable '%s' is not registered", name));
    }

    private Executable lookupByUri(String name, Execute execute, RunnerContext ctx) {
        Class<?> clazz;
        URI uri;
        block9: {
            logger.debug("Looking up by uri - name: {}, execute: {}", (Object)name, (Object)execute);
            try {
                uri = new URI(name);
                if ("bundle-class".equals(uri.getScheme())) break block9;
                logger.debug("Wrong URI scheme: {}", (Object)uri.getScheme());
                return null;
            }
            catch (Exception e) {
                logger.info("Failed to lookup", (Throwable)e);
                return null;
            }
        }
        String host = uri.getHost();
        String clazzName = uri.getPath();
        if (clazzName.startsWith("/")) {
            clazzName = clazzName.substring(1);
        }
        if (clazzName.startsWith(".")) {
            clazzName = String.valueOf(host) + clazzName;
        }
        if (Executable.class.isAssignableFrom(clazz = this.findBundle(host, clazzName))) {
            logger.debug("Return by Executable interface");
            if (clazz.isAnnotationPresent(Singleton.class)) {
                if (!ctx.getSingletons().containsKey(clazz)) {
                    ctx.getSingletons().put(clazz, clazz.newInstance());
                }
                return (Executable)ctx.getSingletons().get(clazz);
            }
            return (Executable)clazz.newInstance();
        }
        String fragment = uri.getFragment();
        if (fragment == null) {
            fragment = "execute";
        }
        logger.debug("Return by call wrapper: #{}", (Object)fragment);
        return this.createCallWrapper(name, clazz, fragment, execute, ctx);
    }

    private Executable createCallWrapper(String name, Class<?> clazz, final String methodName, final Execute execute, RunnerContext ctx) throws Exception {
        Object o;
        logger.debug("Creating call wrapper for class: {}, method: {}", clazz, (Object)methodName);
        if (clazz.isAnnotationPresent(Singleton.class)) {
            if (!ctx.getSingletons().containsKey(clazz)) {
                ctx.getSingletons().put(clazz, clazz.newInstance());
            }
            o = ctx.getSingletons().get(clazz);
        } else {
            o = clazz.newInstance();
        }
        final Method m = this.gatherMethods(clazz, methodName);
        return new Executable(){

            @Override
            public void run(RunnerContext ctx) {
                try {
                    RunnerContext localContext = DefaultExecutableFactory.makeLocalContext(ctx, execute);
                    DefaultExecutableFactory.applyContext(o, localContext);
                    Object[] args = DefaultExecutableFactory.this.makeArgs(m, localContext);
                    m.invoke(o, args);
                    DefaultExecutableFactory.this.captureOutput(o, ctx, (EList<CaptureOutput>)execute.getOutput());
                }
                catch (Throwable e) {
                    logger.info("Method call failed", e);
                    throw new RuntimeException(String.format("Failed to call method: %s", methodName), e);
                }
            }
        };
    }

    private Method gatherMethods(Class<?> clazz, String methodName) {
        LinkedList<Method> methods = new LinkedList<Method>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(methodName)) {
                methods.add(m);
            }
            ++n2;
        }
        if (methods.size() == 1) {
            return (Method)methods.peek();
        }
        if (methods.isEmpty()) {
            throw new IllegalStateException(String.format("Method '%s' not found on class '%s'", methodName, clazz.getName()));
        }
        throw new IllegalStateException(String.format("Method '%s' of class '%s' is polymorphic. This is now allowed for the recipe target classes.", methodName, clazz.getName()));
    }

    protected void captureOutput(Object o, RunnerContext ctx, EList<CaptureOutput> outputs) throws Exception {
        block0: for (CaptureOutput output : outputs) {
            String name = output.getLocalName();
            String storeName = output.getContextName() == null ? name : output.getContextName();
            logger.debug("Capture output: {} -> {}", (Object)name, (Object)storeName);
            BeanInfo bi = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
            int n = propertyDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                if (pd.getName().equals(name)) {
                    Object value = pd.getReadMethod().invoke(o, new Object[0]);
                    ctx.getMap().put(storeName, value);
                    logger.debug("By BeanInfo - value: {}", value);
                    continue block0;
                }
                ++n2;
            }
            Field field = Reflections.findField(o.getClass(), (String)name);
            if (field != null && field.getAnnotation(Output.class) != null) {
                Object value = InjectHelper.getField((Object)o, (Field)field);
                ctx.getMap().put(storeName, value);
                logger.debug("By field - value: {}", value);
                continue;
            }
            if (field != null) {
                throw new IllegalStateException(String.format("Unable to capture output. Field '%s' of class '%s' is not marked with @Output and is not accessible using a getter.", new Object[0]));
            }
            throw new IllegalStateException(String.format("Unable to capture output '%s' of class '%s'", name, o.getClass()));
        }
    }

    protected static RunnerContext makeLocalContext(RunnerContext ctx, Execute execute) {
        HashMap<String, Object> map = new HashMap<String, Object>(ctx.getMap());
        for (MapInput mapInput : execute.getMapInput()) {
            if (!map.containsKey(mapInput.getContextName())) {
                throw new IllegalStateException(String.format("Invalid input mapping - context entry '%s' does not exists", mapInput.getContextName()));
            }
            map.put(mapInput.getLocalName(), map.remove(mapInput.getContextName()));
        }
        for (InputValue value : execute.getInputValue()) {
            map.put(value.getName(), value.getValue());
        }
        for (InputReference ref : execute.getInputReference()) {
            map.put(ref.getName(), DefaultExecutableFactory.getReference(ctx.getMap(), ref.getExpression()));
        }
        RunnerContext result = new RunnerContext(ctx.getProperties());
        result.getMap().putAll(map);
        return result;
    }

    private static Object getReference(Map<String, Object> map, String expression) {
        try {
            return PropertyUtils.getProperty(map, (String)expression);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object[] makeArgs(Method m, RunnerContext localContext) {
        Object[] args = new Object[m.getParameterTypes().length];
        int i = 0;
        while (i < m.getParameterTypes().length) {
            Annotation[] an = m.getParameterAnnotations()[i];
            boolean optional = this.isOptional(an);
            String name = this.makeName(an);
            if (name != null) {
                args[i] = localContext.getMap().get(name);
            } else {
                HashSet<Object> values = new HashSet<Object>(localContext.getMap().values());
                values.add(localContext);
                Class<?> type = m.getParameterTypes()[i];
                args[i] = this.findForType(values, type, i, m.getName(), m.getDeclaringClass(), optional);
            }
            ++i;
        }
        return args;
    }

    private boolean isOptional(Annotation[] an) {
        Annotation[] annotationArray = an;
        int n = an.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a instanceof Optional) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Object findForType(Set<Object> values, Class<?> type, int index, String methodName, Class<?> clazz, boolean optional) {
        for (Object value : values) {
            if (!type.isAssignableFrom(value.getClass())) continue;
            return value;
        }
        if (!optional) {
            throw new IllegalStateException(String.format("Unable to find context value for parameter #%s (type: %s) of method '%s' on class '%s'", index, type.getName(), methodName, clazz.getName()));
        }
        return null;
    }

    private String makeName(Annotation[] an) {
        Annotation[] annotationArray = an;
        int n = an.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a instanceof Named) {
                return ((Named)a).value();
            }
            ++n2;
        }
        return null;
    }

    protected static void applyContext(Object o, RunnerContext ctx) {
        Collection fields = Reflections.findAllFields(o.getClass());
        InjectHelper.injectFields((Object)o, (Collection)fields, ctx.getMap(), Arrays.asList(ctx));
    }

    private Class<?> findBundle(String symbolicName, String clazzName) {
        logger.debug("Find bundle with class - symbolicName: {}, className: {}", (Object)symbolicName, (Object)clazzName);
        BundleContext context = FrameworkUtil.getBundle(DefaultExecutableFactory.class).getBundleContext();
        Bundle[] bundleArray = context.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Bundle bundle = bundleArray[n2];
                if (symbolicName.equals(bundle.getSymbolicName())) {
                    Class clazz;
                    logger.debug("Checking bundle: {}", (Object)bundle.getSymbolicName());
                    try {
                        clazz = bundle.loadClass(clazzName);
                    }
                    catch (ClassNotFoundException e) {
                        logger.debug("Class could not be loaded", (Throwable)e);
                        break block4;
                    }
                    logger.debug("Success");
                    return clazz;
                }
            }
            ++n2;
        }
        return null;
    }
}

