/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.hd.hdsspy.editors;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ide.hd.hdsspy.Activator;
import org.eclipse.scada.ide.hd.hdsspy.editors.ArchiveEntry;
import org.eclipse.swt.graphics.RGB;

public class EntryLabelProvider
extends StyledCellLabelProvider {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void update(ViewerCell cell) {
        ArchiveEntry entry = (ArchiveEntry)cell.getElement();
        if (cell.getColumnIndex() == 0 && entry.isHeartbeat()) {
            if (entry.isDeleted()) {
                cell.setImage(this.resourceManager.createImageWithDefault(Activator.getImageDescriptor("icons/heart-empty.png")));
            } else {
                cell.setImage(this.resourceManager.createImageWithDefault(Activator.getImageDescriptor("icons/heart.png")));
            }
        }
        if (entry.isDeleted()) {
            cell.setForeground(this.resourceManager.createColor(new RGB(128, 128, 128)));
        } else if (entry.isError()) {
            cell.setForeground(this.resourceManager.createColor(new RGB(255, 0, 0)));
        }
        switch (cell.getColumnIndex()) {
            case 0: {
                cell.setText(DATE_FORMAT.format(entry.getTimestamp()));
                break;
            }
            case 1: {
                cell.setText("" + entry.getValue());
                break;
            }
            case 2: {
                cell.setText(this.makeCheck(entry.isError()));
                break;
            }
            case 3: {
                cell.setText(this.makeCheck(entry.isManual()));
                break;
            }
            case 4: {
                cell.setText(this.makeCheck(entry.isDeleted()));
                break;
            }
            case 5: {
                cell.setText(this.makeCheck(entry.isHeartbeat()));
            }
        }
    }

    private String makeCheck(boolean state) {
        return state ? "X" : "";
    }

    public void dispose() {
        super.dispose();
    }
}

