/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.hd.hdsspy.editors;

import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.scada.ide.hd.hdsspy.editors.EntryLabelProvider;
import org.eclipse.scada.ide.hd.hdsspy.editors.FileLoader;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class HDSEditor
extends EditorPart {
    private TableViewer viewer;
    private WritableList entries;
    private FileLoader loader;
    private ObservableListContentProvider contentProvider;
    private EntryLabelProvider labelProvider;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IFileEditorInput fileInput = (IFileEditorInput)AdapterHelper.adapt((Object)input, IFileEditorInput.class);
        if (fileInput != null) {
            this.loader = new FileLoader(fileInput);
            this.setContentDescription(fileInput.getName());
            this.setPartName(fileInput.getName());
        }
        if (this.loader == null) {
            throw new PartInitException("Invalid editor input. Unable to load data");
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
        this.labelProvider.dispose();
        this.contentProvider.dispose();
        if (this.entries != null) {
            this.entries.dispose();
        }
    }

    public void createPartControl(Composite parent) {
        this.entries = new WritableList(DisplayRealm.getRealm((Display)parent.getDisplay()));
        this.viewer = new TableViewer(parent, 65538);
        this.viewer.getTable().setHeaderVisible(true);
        this.contentProvider = new ObservableListContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Timestamp");
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Value");
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Error");
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Manual");
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Deleted");
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText("Heartbeat");
        this.labelProvider = new EntryLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.entries);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        this.viewer.getTable().setLayout((Layout)tableLayout);
        this.entries.setStale(true);
        try {
            try {
                this.loader.performLoad(this.entries);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e.getStatus(), 4);
                this.entries.setStale(false);
            }
        }
        finally {
            this.entries.setStale(false);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

