/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.server.test;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.exporter.Export;
import org.eclipse.scada.da.server.exporter.NgpExport;
import org.eclipse.scada.da.server.ui.HivesPlugin;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.ide.server.test.NgpExportPage;
import org.eclipse.scada.ide.server.test.TestServerDescriptorImpl;
import org.eclipse.scada.ide.server.test.hive.TestHive;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTestWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = LoggerFactory.getLogger(NewTestWizard.class);
    private NgpExportPage ngpPage;

    public NewTestWizard() {
        this.setWindowTitle("Create new test server instance");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            this.handleFinish();
            return true;
        }
        catch (Exception e) {
            logger.info("Failed to start server", (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)StatusHelper.convertStatus((String)"org.eclipse.scada.ide.server.test", (Throwable)e));
            return false;
        }
    }

    protected void handleFinish() throws Exception {
        HashSet<Export> exporters = new HashSet<Export>();
        TestHive hive = new TestHive();
        NgpExport ngpExport = this.createNgpExport((Hive)hive);
        if (ngpExport != null) {
            exporters.add((Export)ngpExport);
        }
        TestServerDescriptorImpl desc = new TestServerDescriptorImpl(SWTObservables.getRealm((Display)Display.getDefault()), (Hive)hive, exporters, "Foo Bar");
        HivesPlugin.registerServer((ServerDescriptor)desc);
    }

    private NgpExport createNgpExport(Hive hive) throws Exception {
        ConnectionInformation ci = this.ngpPage.getConnectionInformation();
        if (ci == null) {
            return null;
        }
        return new NgpExport(hive, ci);
    }

    public void addPages() {
        this.ngpPage = new NgpExportPage();
        this.addPage((IWizardPage)this.ngpPage);
    }
}

