/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.EquinoxBase;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.world.Driver;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.configuration.world.osgi.ConfigurationAdministratorExporter;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public abstract class AbstractEquinoxDriverFactory<T extends Driver & EquinoxApplication>
implements DriverFactory {
    private final List<DriverValidator<EquinoxDriver>> validators = new LinkedList<DriverValidator<EquinoxDriver>>();

    protected abstract void configureDriver(AbstractFactoryDriver var1, T var2, Map<Node, org.eclipse.scada.configuration.world.Node> var3);

    protected abstract T createDriver();

    public AbstractEquinoxDriverFactory() {
        this.validators.add(new DriverValidator<EquinoxDriver>(){

            @Override
            public void validate(ValidationContext ctx, EquinoxDriver driver) {
                if (Worlds.findUserService((EquinoxBase)driver) == null) {
                    ctx.add(Severity.WARNING, new Object[]{driver}, "Neither the driver has set a user service nor is there a default in the global options", new Object[0]);
                }
                if (Worlds.findSecurityConfiguration((EquinoxBase)driver) == null) {
                    ctx.add(Severity.WARNING, new Object[]{driver}, "Neither the driver has set a security policy nor is there a default in the root", new Object[0]);
                }
            }
        });
    }

    protected void addValidator(DriverValidator<EquinoxDriver> validator) {
        this.validators.add(validator);
    }

    @Override
    public Driver createDriver(World world, AbstractFactoryDriver driver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes) {
        T result = this.createDriver();
        EquinoxDriver eDriver = (EquinoxDriver)driver;
        DataAccessExporter exporter = OsgiFactory.eINSTANCE.createDataAccessExporter();
        exporter.setName("exporter");
        ((EquinoxApplication)result).getExporter().add((Object)exporter);
        exporter.getEndpoints().add((Object)Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)nodes.get(driver.getNode()), (int)(world.getOptions().getBaseDaNgpPort() + eDriver.getInstanceNumber()), (ServiceBinding)Endpoints.reference((EObject)exporter), (String)("EquinoxDriver Endpoint: " + driver.getName())));
        ConfigurationAdministratorExporter caExporter = OsgiFactory.eINSTANCE.createConfigurationAdministratorExporter();
        caExporter.setName("caExporter");
        ((EquinoxApplication)result).getExporter().add((Object)caExporter);
        caExporter.getEndpoints().add((Object)Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)nodes.get(driver.getNode()), (int)(world.getOptions().getBaseCaNgpPort() + eDriver.getInstanceNumber()), (ServiceBinding)Endpoints.reference((EObject)caExporter), (String)("CA Exporter: " + driver.getName())));
        Worlds.addUserService(result, (EquinoxBase)eDriver);
        ((EquinoxApplication)result).setSecurityConfiguration(Worlds.findSecurityConfiguration((EquinoxBase)eDriver));
        ((EquinoxApplication)result).getModules().addAll(WorldGenerator.makeModules(world, (EquinoxBase)eDriver, result));
        this.configureDriver(driver, result, nodes);
        return result;
    }

    @Override
    public void validate(ValidationContext ctx, AbstractFactoryDriver driver) {
        if (!(driver instanceof EquinoxDriver)) {
            ctx.add("Driver factory of type {0} can only process driver of type {1}", new Object[]{this.getClass().getSimpleName(), EquinoxDriver.class.getSimpleName()});
            return;
        }
        this.performValidation(ctx, (EquinoxDriver)driver);
    }

    protected void performValidation(ValidationContext ctx, EquinoxDriver driver) {
        for (DriverValidator<EquinoxDriver> validator : this.validators) {
            validator.validate(ctx, driver);
        }
    }
}

